/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.io.IOException;
import java.util.Set;
import javax.management.JMException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.Version;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.RequestHandler;
import org.jolokia.server.core.util.RequestType;

public class VersionRequestHandler
extends AbstractJolokiaService<RequestHandler>
implements RequestHandler {
    private JolokiaContext context;
    private static final Set<ConfigKey> hiddenGlobalKeys = Set.of(ConfigKey.USER, ConfigKey.PASSWORD);

    VersionRequestHandler() {
        super(RequestHandler.class, -1);
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
        this.context = pJolokiaContext;
    }

    public Object handleRequest(JolokiaRequest pJmxReq, Object pPreviousResult) throws JMException, IOException, NotChangedException {
        JSONObject ret = new JSONObject();
        ret.put((Object)"agent", (Object)Version.getAgentVersion());
        ret.put((Object)"protocol", (Object)Version.getProtocolVersion());
        ret.put((Object)"id", (Object)this.context.getConfig(ConfigKey.AGENT_ID));
        AgentDetails agentDetails = this.context.getAgentDetails();
        if (agentDetails != null) {
            ret.put((Object)"details", (Object)agentDetails.toJSONObject());
        }
        JSONObject info = new JSONObject();
        for (RequestHandler handler : this.context.getServices(RequestHandler.class)) {
            if (handler == this || handler.getProvider() == null) continue;
            Object rtInfo = handler.getRuntimeInfo();
            info.put((Object)handler.getProvider(), rtInfo != null ? rtInfo : new JSONObject());
        }
        ret.put((Object)"info", (Object)info);
        ret.put((Object)"config", (Object)this.configToJSONObject());
        JSONObject updaters = new JSONObject();
        for (DataUpdater updater : this.context.getServices(DataUpdater.class)) {
            JSONObject updaterInfo;
            String key = updater.getKey();
            if (key == null) {
                key = updater.getClass().getName();
            }
            if ((updaterInfo = updater.getInfo()) == null) {
                updaterInfo = new JSONObject();
            }
            updaters.put((Object)key, (Object)updaterInfo);
        }
        ret.put((Object)"decorators", (Object)updaters);
        return ret;
    }

    @Override
    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        return pJolokiaRequest.getType() == RequestType.VERSION;
    }

    private JSONObject configToJSONObject() {
        JSONObject info = new JSONObject();
        Set<ConfigKey> keys = this.context.getConfigKeys();
        boolean hasDateFormat = false;
        for (ConfigKey key : keys) {
            if (key == ConfigKey.DATE_FORMAT) {
                hasDateFormat = true;
            }
            if (!key.isGlobalConfig() || hiddenGlobalKeys.contains((Object)key)) continue;
            info.put((Object)key.getKeyValue(), (Object)this.context.getConfig(key));
        }
        if (!hasDateFormat) {
            info.put((Object)ConfigKey.DATE_FORMAT.getKeyValue(), (Object)ConfigKey.DATE_FORMAT.getDefaultValue());
        }
        return info;
    }

    @Override
    public String getProvider() {
        return null;
    }

    @Override
    public Object getRuntimeInfo() {
        return null;
    }
}

