/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.audit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.audit.AuditEvent;
import org.apache.zookeeper.audit.Slf4jAuditLogger;
import org.apache.zookeeper.audit.ZKAuditProvider;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.util.AuthUtil;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.LoggerTestTool;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JAuditLoggerTest
extends QuorumPeerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4JAuditLoggerTest.class);
    private static int SERVER_COUNT = 3;
    private static QuorumPeerTestBase.MainThread[] mt;
    private static ZooKeeper zk;
    private static ByteArrayOutputStream os;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("zookeeper.audit.enable", "true");
        LoggerTestTool loggerTestTool = new LoggerTestTool(Slf4jAuditLogger.class);
        os = loggerTestTool.getOutputStream();
        mt = Slf4JAuditLoggerTest.startQuorum();
        zk = ClientBase.createZKClient("127.0.0.1:" + mt[0].getQuorumPeer().getClientPort());
        String expectedAuditLog = Slf4JAuditLoggerTest.getStartLog();
        List<String> logs = Slf4JAuditLoggerTest.readAuditLog(os, SERVER_COUNT);
        Slf4JAuditLoggerTest.verifyLogs(expectedAuditLog, logs);
    }

    @BeforeEach
    public void setUp() {
        os.reset();
    }

    @Test
    public void testCreateAuditLogs() throws KeeperException, InterruptedException, IOException {
        String path = "/createPath";
        zk.create(path, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String createMode = CreateMode.PERSISTENT.toString().toLowerCase();
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("create", path, AuditEvent.Result.SUCCESS, null, createMode), this.readAuditLog(os));
        try {
            zk.create(path, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assertions.assertEquals((Object)KeeperException.Code.NODEEXISTS, (Object)code);
        }
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("create", path, AuditEvent.Result.FAILURE, null, createMode), this.readAuditLog(os));
    }

    @Test
    public void testDeleteAuditLogs() throws InterruptedException, IOException, KeeperException {
        String path = "/deletePath";
        zk.create(path, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        os.reset();
        try {
            zk.delete(path, -100);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assertions.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)code);
        }
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("delete", path, AuditEvent.Result.FAILURE), this.readAuditLog(os));
        zk.delete(path, -1);
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("delete", path), this.readAuditLog(os));
    }

    @Test
    public void testSetDataAuditLogs() throws InterruptedException, IOException, KeeperException {
        String path = "/setDataPath";
        zk.create(path, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        os.reset();
        try {
            zk.setData(path, "newData".getBytes(), -100);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assertions.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)code);
        }
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("setData", path, AuditEvent.Result.FAILURE), this.readAuditLog(os));
        zk.setData(path, "newdata".getBytes(), -1);
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("setData", path), this.readAuditLog(os));
    }

    @Test
    public void testSetACLAuditLogs() throws InterruptedException, IOException, KeeperException {
        ArrayList openAclUnsafe = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        String path = "/aclPath";
        zk.create(path, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        os.reset();
        try {
            zk.setACL(path, (List)openAclUnsafe, -100);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assertions.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)code);
        }
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("setAcl", path, AuditEvent.Result.FAILURE, ZKUtil.aclToString((List)openAclUnsafe), null), this.readAuditLog(os));
        zk.setACL(path, (List)openAclUnsafe, -1);
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("setAcl", path, AuditEvent.Result.SUCCESS, ZKUtil.aclToString((List)openAclUnsafe), null), this.readAuditLog(os));
    }

    @Test
    public void testMultiOperationAuditLogs() throws InterruptedException, KeeperException, IOException {
        ArrayList<Op> ops = new ArrayList<Op>();
        String multiop = "/b";
        Op create = Op.create((String)multiop, (byte[])"".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Op setData = Op.setData((String)multiop, (byte[])"newData".getBytes(), (int)-1);
        Op check = Op.check((String)multiop, (int)-1);
        Op delete = Op.delete((String)multiop, (int)-1);
        String createMode = CreateMode.PERSISTENT.toString().toLowerCase();
        ops.add(create);
        ops.add(setData);
        ops.add(check);
        ops.add(delete);
        zk.multi(ops);
        List<String> multiOpLogs = Slf4JAuditLoggerTest.readAuditLog(os, 3);
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("create", multiop, AuditEvent.Result.SUCCESS, null, createMode), multiOpLogs.get(0));
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("setData", multiop), multiOpLogs.get(1));
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("delete", multiop), multiOpLogs.get(2));
        ops = new ArrayList();
        ops.add(create);
        ops.add(create);
        try {
            zk.multi(ops);
        }
        catch (KeeperException exception) {
            KeeperException.Code code = exception.code();
            Assertions.assertEquals((Object)KeeperException.Code.NODEEXISTS, (Object)code);
        }
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("multiOperation", null, AuditEvent.Result.FAILURE), this.readAuditLog(os));
    }

    @Test
    public void testEphemralZNodeAuditLogs() throws Exception {
        String ephemralPath = "/ephemral";
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ZooKeeper zk2 = new ZooKeeper("127.0.0.1:" + mt[0].getQuorumPeer().getClientPort(), ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher2);
        watcher2.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zk2.create(ephemralPath, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        String session2 = "0x" + Long.toHexString(zk2.getSessionId());
        Slf4JAuditLoggerTest.verifyLog(this.getAuditLog("create", ephemralPath, AuditEvent.Result.SUCCESS, null, CreateMode.EPHEMERAL.toString().toLowerCase(), session2), this.readAuditLog(os));
        zk2.close();
        this.waitForDeletion(zk, ephemralPath);
        Slf4JAuditLoggerTest.verifyLogs(this.getAuditLog("ephemeralZNodeDeletionOnSessionCloseOrExpire", ephemralPath, AuditEvent.Result.SUCCESS, null, null, session2, ZKAuditProvider.getZKUser(), null), Slf4JAuditLoggerTest.readAuditLog(os, SERVER_COUNT));
    }

    private static String getStartLog() {
        AuditEvent logEvent = ZKAuditProvider.createLogEvent((String)ZKAuditProvider.getZKUser(), (String)"serverStart", (AuditEvent.Result)AuditEvent.Result.SUCCESS);
        return logEvent.toString();
    }

    private String getAuditLog(String operation, String znode) {
        return this.getAuditLog(operation, znode, AuditEvent.Result.SUCCESS);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result) {
        return this.getAuditLog(operation, znode, result, null, null);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result, String acl, String createMode) {
        String session = this.getSession();
        return this.getAuditLog(operation, znode, result, acl, createMode, session);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result, String acl, String createMode, String session) {
        String user = this.getUser();
        String ip = this.getIp();
        return this.getAuditLog(operation, znode, result, acl, createMode, session, user, ip);
    }

    private String getAuditLog(String operation, String znode, AuditEvent.Result result, String acl, String createMode, String session, String user, String ip) {
        AuditEvent logEvent = ZKAuditProvider.createLogEvent((String)user, (String)operation, (String)znode, (String)acl, (String)createMode, (String)session, (String)ip, (AuditEvent.Result)result);
        String auditLog = logEvent.toString();
        LOG.info("expected audit log for operation '" + operation + "' is '" + auditLog + "'");
        return auditLog;
    }

    private String getSession() {
        return "0x" + Long.toHexString(zk.getSessionId());
    }

    private String getUser() {
        ServerCnxn next = this.getServerCnxn();
        return AuthUtil.getUsers((List)next.getAuthInfo());
    }

    private String getIp() {
        ServerCnxn next = this.getServerCnxn();
        InetSocketAddress remoteSocketAddress = next.getRemoteSocketAddress();
        InetAddress address = remoteSocketAddress.getAddress();
        return address.getHostAddress();
    }

    private ServerCnxn getServerCnxn() {
        Iterable connections = mt[0].getQuorumPeer().getActiveServer().getServerCnxnFactory().getConnections();
        return (ServerCnxn)connections.iterator().next();
    }

    private static void verifyLog(String expectedLog, String log) {
        String searchString = " - ";
        int logStartIndex = log.indexOf(searchString);
        String auditLog = log.substring(logStartIndex + searchString.length());
        Assertions.assertTrue((boolean)auditLog.endsWith(expectedLog));
    }

    private static void verifyLogs(String expectedLog, List<String> logs) {
        for (String log : logs) {
            Slf4JAuditLoggerTest.verifyLog(expectedLog, log);
        }
    }

    private String readAuditLog(ByteArrayOutputStream os) throws IOException {
        return Slf4JAuditLoggerTest.readAuditLog(os, 1).get(0);
    }

    private static List<String> readAuditLog(ByteArrayOutputStream os, int numberOfLogEntry) throws IOException {
        return Slf4JAuditLoggerTest.readAuditLog(os, numberOfLogEntry, false);
    }

    private static List<String> readAuditLog(ByteArrayOutputStream os, int numberOfLogEntry, boolean skipEphemralDeletion) throws IOException {
        String line;
        ArrayList<String> logs = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        while ((line = r.readLine()) != null) {
            if (skipEphemralDeletion && line.contains("ephemeralZNodeDeletionOnSessionCloseOrExpire")) continue;
            logs.add(line);
        }
        os.reset();
        Assertions.assertEquals((int)numberOfLogEntry, (int)logs.size(), (String)("Expected number of log entries are not generated. Logs are " + logs));
        return logs;
    }

    private static QuorumPeerTestBase.MainThread[] startQuorum() throws IOException {
        int i;
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        sb.append("4lw.commands.whitelist=*");
        sb.append("\n");
        for (int i2 = 0; i2 < SERVER_COUNT; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server);
            sb.append("\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];
        for (i = 0; i < SERVER_COUNT; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
        }
        return mt;
    }

    private void waitForDeletion(ZooKeeper zooKeeper, String path) throws Exception {
        long waitInterval = 10L;
        int timeout = 100;
        Stat exists = zooKeeper.exists(path, false);
        for (long elapsedTime = 0L; exists != null && elapsedTime < (long)timeout; elapsedTime += waitInterval) {
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"CurrentEpoch update failed");
            }
            exists = zooKeeper.exists(path, false);
        }
        Assertions.assertNull((Object)exists, (String)("Node " + path + " not deleted in " + timeout + " ms"));
    }

    @AfterAll
    public static void tearDownAfterClass() {
        System.clearProperty("zookeeper.audit.enable");
        for (int i = 0; i < SERVER_COUNT; ++i) {
            try {
                if (mt[i] == null) continue;
                mt[i].shutdown();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

