/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.auth.IPAuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ACLTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private volatile CountDownLatch startSignal;

    @Test
    public void testIPAuthenticationIsValidCIDR() throws Exception {
        IPAuthenticationProvider prov = new IPAuthenticationProvider();
        Assertions.assertTrue((boolean)prov.isValid("127.0.0.1"), (String)"testing no netmask");
        Assertions.assertTrue((boolean)prov.isValid("127.0.0.1/32"), (String)"testing single ip netmask");
        Assertions.assertTrue((boolean)prov.isValid("127.0.0.1/0"), (String)"testing lowest netmask possible");
        Assertions.assertFalse((boolean)prov.isValid("127.0.0.1/33"), (String)"testing netmask too high");
        Assertions.assertFalse((boolean)prov.isValid("10.0.0.1/-1"), (String)"testing netmask too low");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyIpAuthDefault() throws Exception {
        String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        ClientBase.setupTestEnv();
        File tmpDir = ClientBase.createTmpDir();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
            ClientBase.createZKClient(HOSTPORT);
            for (ServerCnxn cnxn : f.getConnections()) {
                boolean foundID = false;
                for (Id id : cnxn.getAuthInfo()) {
                    if (!id.getScheme().equals("ip")) continue;
                    foundID = true;
                    break;
                }
                Assertions.assertTrue((boolean)foundID);
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
            System.clearProperty("zookeeper.serverCnxnFactory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisconnectedAddAuth() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
            try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
                zk.addAuthInfo("digest", "pat:test".getBytes());
                zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcls() throws Exception {
        String path;
        ZooKeeper zk;
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
            zk = ClientBase.createZKClient(HOSTPORT);
            LOG.info("starting creating acls");
            for (int i = 0; i < 100; ++i) {
                path = "/" + i;
                zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            int size = zks.getZKDatabase().getAclSize();
            Assertions.assertTrue((2 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0, (String)"size of the acl map ");
            for (int j = 100; j < 200; ++j) {
                path = "/" + j;
                ACL acl = new ACL();
                acl.setPerms(0);
                Id id = new Id();
                id.setId("1.1.1." + j);
                id.setScheme("ip");
                acl.setId(id);
                ArrayList<ACL> list = new ArrayList<ACL>();
                list.add(acl);
                zk.create(path, path.getBytes(), list, CreateMode.PERSISTENT);
            }
            Assertions.assertTrue((102 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0, (String)"size of the acl map ");
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server up");
            zk = ClientBase.createZKClient(HOSTPORT);
            Assertions.assertTrue((102 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0, (String)"acl map ");
            for (int j = 200; j < 205; ++j) {
                path = "/" + j;
                ACL acl = new ACL();
                acl.setPerms(0);
                Id id = new Id();
                id.setId("1.1.1." + j);
                id.setScheme("ip");
                acl.setId(id);
                ArrayList<ACL> list = new ArrayList<ACL>();
                list.add(acl);
                zk.create(path, path.getBytes(), list, CreateMode.PERSISTENT);
            }
            Assertions.assertTrue((107 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0, (String)"acl map ");
            zk.close();
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:{} {} {}", new Object[]{event.getState(), event.getType(), event.getPath()});
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            if (this.startSignal != null && this.startSignal.getCount() > 0L) {
                LOG.info("startsignal.countDown()");
                this.startSignal.countDown();
            } else {
                LOG.warn("startsignal {}", (Object)this.startSignal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullACL() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        try {
            try {
                zk.create("/foo", "foo".getBytes(), null, CreateMode.PERSISTENT);
                Assertions.fail((String)"Expected InvalidACLException for null ACL parameter");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.create("/foo", "foo".getBytes(), null, CreateMode.PERSISTENT, null);
                Assertions.fail((String)"Expected InvalidACLException for null ACL parameter");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.setACL("/foo", null, 0);
                Assertions.fail((String)"Expected InvalidACLException for null ACL parameter");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
        }
        finally {
            zk.close();
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullValueACL() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        try {
            ArrayList<Object> acls = new ArrayList<Object>();
            acls.add(null);
            try {
                zk.create("/foo", "foo".getBytes(), acls, CreateMode.PERSISTENT);
                Assertions.fail((String)"Expected InvalidACLException for null value in ACL List");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.create("/foo", "foo".getBytes(), acls, CreateMode.PERSISTENT, null);
                Assertions.fail((String)"Expected InvalidACLException for null value in ACL List");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
            try {
                zk.setACL("/foo", acls, -1);
                Assertions.fail((String)"Expected InvalidACLException for null value in ACL List");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {
                // empty catch block
            }
        }
        finally {
            zk.close();
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistACLCheck() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        String path = "/testExistACLCheck";
        String data = "/testExistACLCheck-data";
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
            try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
                Stat stat = zk.exists(path, false);
                Assertions.assertNull((Object)stat);
                zk.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                stat = zk.exists(path, false);
                Assertions.assertNotNull((Object)stat);
                Assertions.assertEquals((int)data.length(), (int)stat.getDataLength());
                zk.delete(path, -1);
                ArrayList<ACL> acls = new ArrayList<ACL>();
                acls.add(new ACL(2, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                zk.create(path, data.getBytes(), acls, CreateMode.PERSISTENT);
                try {
                    stat = zk.exists(path, false);
                    Assertions.fail((String)"exists should throw NoAuthException when don't have read permission");
                }
                catch (KeeperException.NoAuthException noAuthException) {
                    // empty catch block
                }
                zk.delete(path, -1);
                acls = new ArrayList();
                acls.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                zk.create(path, data.getBytes(), acls, CreateMode.PERSISTENT);
                stat = zk.exists(path, false);
                Assertions.assertNotNull((Object)stat);
                Assertions.assertEquals((int)data.length(), (int)stat.getDataLength());
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistACLCheckAtRootPath() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
            try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
                String data = "/testExistACLCheckAtRootPath-data";
                zk.create("/a", data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                ArrayList<ACL> acls = new ArrayList<ACL>();
                acls.add(new ACL(0, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                zk.setACL("/", acls, -1);
                Stat stat = zk.exists("/a", false);
                Assertions.assertNotNull((Object)stat);
                Assertions.assertEquals((int)data.length(), (int)stat.getDataLength());
                try {
                    stat = zk.exists("/", false);
                    Assertions.fail((String)"exists should throw NoAuthException when removing root path's ACL permission");
                }
                catch (KeeperException.NoAuthException noAuthException) {
                    // empty catch block
                }
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
    }
}

