/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.admin;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.clients.SimpleClientBase;
import org.apache.bookkeeper.clients.SimpleStorageClientImpl;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.bookkeeper.clients.utils.GrpcUtils;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.ListenableFutures;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;

public class SimpleStorageAdminClientImpl
extends SimpleClientBase
implements StorageAdminClient {
    private final RootRangeServiceGrpc.RootRangeServiceFutureStub rootRangeService;

    public SimpleStorageAdminClientImpl(StorageClientSettings settings) {
        this(settings, ClientResources.create().scheduler());
    }

    public SimpleStorageAdminClientImpl(StorageClientSettings settings, SharedResourceManager.Resource<OrderedScheduler> schedulerResource) {
        super(settings, schedulerResource);
        this.rootRangeService = GrpcUtils.configureGrpcStub(RootRangeServiceGrpc.newFutureStub(this.channel), Optional.empty());
    }

    @Override
    public StorageClient asClient(String namespace) {
        return new SimpleStorageClientImpl(namespace, this.settings, (SharedResourceManager.Resource<OrderedScheduler>)this.schedulerResource, this.managedChannel);
    }

    @Override
    public CompletableFuture<NamespaceProperties> createNamespace(String namespace, NamespaceConfiguration conf) {
        return this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(this.rootRangeService.createNamespace(ProtoUtils.createCreateNamespaceRequest(namespace, conf)))).thenCompose(resp -> {
            if (StatusCode.SUCCESS == resp.getCode()) {
                return FutureUtils.value((Object)resp.getNsProps());
            }
            return FutureUtils.exception((Throwable)ProtocolInternalUtils.createRootRangeException(namespace, resp.getCode()));
        });
    }

    @Override
    public CompletableFuture<Boolean> deleteNamespace(String namespace) {
        return this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(this.rootRangeService.deleteNamespace(ProtoUtils.createDeleteNamespaceRequest(namespace)))).thenCompose(resp -> {
            if (StatusCode.SUCCESS == resp.getCode()) {
                return FutureUtils.value((Object)true);
            }
            return FutureUtils.exception((Throwable)ProtocolInternalUtils.createRootRangeException(namespace, resp.getCode()));
        });
    }

    @Override
    public CompletableFuture<NamespaceProperties> getNamespace(String namespace) {
        return this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(this.rootRangeService.getNamespace(ProtoUtils.createGetNamespaceRequest(namespace)))).thenCompose(resp -> {
            if (StatusCode.SUCCESS == resp.getCode()) {
                return FutureUtils.value((Object)resp.getNsProps());
            }
            return FutureUtils.exception((Throwable)ProtocolInternalUtils.createRootRangeException(namespace, resp.getCode()));
        });
    }

    @Override
    public CompletableFuture<StreamProperties> createStream(String namespace, String streamName, StreamConfiguration streamConfiguration) {
        return this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(this.rootRangeService.createStream(ProtoUtils.createCreateStreamRequest(namespace, streamName, streamConfiguration)))).thenCompose(resp -> {
            if (StatusCode.SUCCESS == resp.getCode()) {
                return FutureUtils.value((Object)resp.getStreamProps());
            }
            return FutureUtils.exception((Throwable)ProtocolInternalUtils.createRootRangeException(namespace, resp.getCode()));
        });
    }

    @Override
    public CompletableFuture<Boolean> deleteStream(String namespace, String streamName) {
        return this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(this.rootRangeService.deleteStream(ProtoUtils.createDeleteStreamRequest(namespace, streamName)))).thenCompose(resp -> {
            if (StatusCode.SUCCESS == resp.getCode()) {
                return FutureUtils.value((Object)true);
            }
            return FutureUtils.exception((Throwable)ProtocolInternalUtils.createRootRangeException(namespace, resp.getCode()));
        });
    }

    @Override
    public CompletableFuture<StreamProperties> getStream(String namespace, String streamName) {
        return this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(this.rootRangeService.getStream(ProtoUtils.createGetStreamRequest(namespace, streamName)))).thenCompose(resp -> {
            if (StatusCode.SUCCESS == resp.getCode()) {
                return FutureUtils.value((Object)resp.getStreamProps());
            }
            return FutureUtils.exception((Throwable)ProtocolInternalUtils.createRootRangeException(namespace, resp.getCode()));
        });
    }
}

