/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientBuilder;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLConfig;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLMetadata {
    static final Logger LOG = LoggerFactory.getLogger(DLMetadata.class);
    static final String LINE_SPLITTER = "\n";
    static final String BK_DL_TYPE = "BKDL";
    static final int METADATA_FORMAT_VERSION = 1;
    private int metadataFormatVersion = 0;
    private String dlType;
    private DLConfig dlConfig;

    public DLMetadata(String dlType, DLConfig dlConfig) {
        this(dlType, dlConfig, 1);
    }

    DLMetadata(String dlType, DLConfig dlConfig, int metadataFormatVersion) {
        this.dlType = dlType;
        this.dlConfig = dlConfig;
        this.metadataFormatVersion = metadataFormatVersion;
    }

    public String getDLType() {
        return this.dlType;
    }

    public DLConfig getDLConfig() {
        return this.dlConfig;
    }

    public byte[] serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.metadataFormatVersion).append(LINE_SPLITTER);
        sb.append(this.dlType).append(LINE_SPLITTER);
        sb.append(this.dlConfig.serialize());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialized dl metadata {}.", (Object)sb);
        }
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return this.dlType.hashCode() * 13 + this.dlConfig.hashCode();
    }

    public String toString() {
        return new String(this.serialize(), StandardCharsets.UTF_8);
    }

    public void update(URI uri) throws IOException {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        byte[] data = this.serialize();
        try (ZooKeeperClient zkc = ZooKeeperClientBuilder.newBuilder().sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).retryThreadCount(conf.getZKClientNumberRetryThreads()).requestRateLimit(conf.getZKRequestRateLimit()).zkAclId(conf.getZkAclId()).uri(uri).build();){
            zkc.get().setData(uri.getPath(), data, -1);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DLMetadata)) {
            return false;
        }
        DLMetadata other = (DLMetadata)o;
        return this.dlType.equals(other.dlType) && this.dlConfig.equals(other.dlConfig);
    }

    public void create(URI uri) throws IOException {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        byte[] data = this.serialize();
        try (ZooKeeperClient zkc = ZooKeeperClientBuilder.newBuilder().sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).retryThreadCount(conf.getZKClientNumberRetryThreads()).requestRateLimit(conf.getZKRequestRateLimit()).zkAclId(conf.getZkAclId()).uri(uri).build();){
            Utils.zkCreateFullPathOptimistic(zkc, uri.getPath(), data, zkc.getDefaultACL(), CreateMode.PERSISTENT);
        }
    }

    public static void unbind(URI uri) throws IOException {
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        byte[] data = new byte[]{};
        try (ZooKeeperClient zkc = ZooKeeperClientBuilder.newBuilder().sessionTimeoutMs(conf.getZKSessionTimeoutMilliseconds()).retryThreadCount(conf.getZKClientNumberRetryThreads()).requestRateLimit(conf.getZKRequestRateLimit()).zkAclId(conf.getZkAclId()).uri(uri).build();){
            zkc.get().setData(uri.getPath(), data, -1);
        }
    }

    public static DLMetadata deserialize(URI uri, byte[] data) throws IOException {
        String line;
        int version;
        BufferedReader br;
        String versionLine;
        String metadata = new String(data, StandardCharsets.UTF_8);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing dl metadata {}.", (Object)metadata);
        }
        if (null == (versionLine = (br = new BufferedReader(new StringReader(metadata))).readLine())) {
            throw new IOException("Empty DL Metadata.");
        }
        try {
            version = Integer.parseInt(versionLine);
        }
        catch (NumberFormatException nfe) {
            version = -1;
        }
        if (1 != version) {
            throw new IOException("Metadata version not compatible. Expected 1 but got " + version);
        }
        String type = br.readLine();
        if (!BK_DL_TYPE.equals(type)) {
            throw new IOException("Invalid DL type : " + type);
        }
        BKDLConfig dlConfig = new BKDLConfig(uri);
        StringBuilder sb = new StringBuilder();
        while (null != (line = br.readLine())) {
            sb.append(line);
        }
        dlConfig.deserialize(sb.toString().getBytes(StandardCharsets.UTF_8));
        return new DLMetadata(type, dlConfig, version);
    }

    public static DLMetadata create(BKDLConfig bkdlConfig) {
        return new DLMetadata(BK_DL_TYPE, bkdlConfig);
    }
}

