/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceSnitch;
import org.apache.cassandra.locator.Ec2MetadataServiceConnector;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.Pair;

public class Ec2Snitch
extends AbstractCloudMetadataServiceSnitch {
    private static final String SNITCH_PROP_NAMING_SCHEME = "ec2_naming_scheme";
    static final String EC2_NAMING_LEGACY = "legacy";
    private static final String EC2_NAMING_STANDARD = "standard";
    @VisibleForTesting
    public static final String ZONE_NAME_QUERY = "/latest/meta-data/placement/availability-zone";
    private final boolean usingLegacyNaming;

    public Ec2Snitch() throws IOException, ConfigurationException {
        this(new SnitchProperties());
    }

    public Ec2Snitch(SnitchProperties props) throws IOException, ConfigurationException {
        this(Ec2MetadataServiceConnector.create(props));
    }

    Ec2Snitch(AbstractCloudMetadataServiceConnector connector) throws IOException {
        super(connector, Ec2Snitch.getDcAndRack(connector));
        this.usingLegacyNaming = Ec2Snitch.isUsingLegacyNaming(connector.getProperties());
    }

    private static Pair<String, String> getDcAndRack(AbstractCloudMetadataServiceConnector connector) throws IOException {
        String region;
        String localRack;
        String az = connector.apiCall(ZONE_NAME_QUERY);
        boolean usingLegacyNaming = Ec2Snitch.isUsingLegacyNaming(connector.getProperties());
        if (usingLegacyNaming) {
            String[] splits = az.split("-");
            localRack = splits[splits.length - 1];
            region = az.substring(0, az.length() - 1);
            if (region.endsWith("1")) {
                region = az.substring(0, az.length() - 3);
            }
        } else {
            region = az.replaceFirst("[a-z]+$", "");
            localRack = az;
        }
        String localDc = region.concat(connector.getProperties().getDcSuffix());
        return Pair.create(localDc, localRack);
    }

    private static boolean isUsingLegacyNaming(SnitchProperties props) {
        return props.get(SNITCH_PROP_NAMING_SCHEME, EC2_NAMING_STANDARD).equalsIgnoreCase(EC2_NAMING_LEGACY);
    }

    @Override
    public boolean validate(Set<String> datacenters, Set<String> racks) {
        return Ec2Snitch.validate(datacenters, racks, this.usingLegacyNaming);
    }

    @VisibleForTesting
    static boolean validate(Set<String> datacenters, Set<String> racks, boolean usingLegacyNaming) {
        boolean valid = true;
        for (String dc : datacenters) {
            boolean dcUsesLegacyFormat = dc.matches("^[a-z]+-[a-z]+$");
            if (!dcUsesLegacyFormat || usingLegacyNaming) continue;
            valid = false;
            break;
        }
        for (String rack : racks) {
            boolean rackUsesLegacyFormat = rack.matches("[\\d][a-z]");
            if (rackUsesLegacyFormat == usingLegacyNaming) continue;
            valid = false;
            break;
        }
        if (!valid) {
            logger.error("This ec2-enabled snitch appears to be using the {} naming scheme for regions, but existing nodes in cluster are using the opposite: region(s) = {}, availability zone(s) = {}. Please check the {} property in the {} configuration file for more details.", new Object[]{usingLegacyNaming ? EC2_NAMING_LEGACY : EC2_NAMING_STANDARD, datacenters, racks, SNITCH_PROP_NAMING_SCHEME, SnitchProperties.RACKDC_PROPERTY_FILENAME});
        }
        return valid;
    }
}

