/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.CassandraInputPartition;
import org.apache.cassandra.spark.sparksql.CassandraPartitionReaderFactory;
import org.apache.cassandra.spark.sparksql.PartitionSizeIterator;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionSizeReaderFactory
implements PartitionReaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraPartitionReaderFactory.class);
    final DataLayer dataLayer;

    PartitionSizeReaderFactory(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        int partitionId;
        if (partition instanceof CassandraInputPartition) {
            partitionId = ((CassandraInputPartition)partition).getPartitionId();
        } else {
            partitionId = TaskContext.getPartitionId();
            LOGGER.warn("InputPartition is not of CassandraInputPartition type. Using TaskContext to determine the partitionId type={}, partitionId={}", (Object)partition.getClass().getName(), (Object)partitionId);
        }
        return new PartitionSizeIterator(partitionId, this.dataLayer);
    }
}

