/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.data.RestoreJobSecrets;
import org.apache.cassandra.sidecar.common.data.RestoreJobStatus;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UpdateRestoreJobRequestPayload {
    private final String jobAgent;
    private final RestoreJobSecrets secrets;
    private final RestoreJobStatus status;
    private final Long expireAtInMillis;
    private final Long sliceCount;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public UpdateRestoreJobRequestPayload(@JsonProperty(value="jobAgent") String jobAgent, @JsonProperty(value="secrets") RestoreJobSecrets secrets, @JsonProperty(value="status") RestoreJobStatus status, @JsonProperty(value="expireAt") Long expireAtInMillis, @JsonProperty(value="sliceCount") Long sliceCount) {
        this.jobAgent = jobAgent;
        this.secrets = secrets;
        this.status = status;
        this.expireAtInMillis = expireAtInMillis;
        this.sliceCount = sliceCount;
    }

    private UpdateRestoreJobRequestPayload(Builder builder) {
        this.jobAgent = builder.jobAgent;
        this.secrets = builder.secrets;
        this.status = builder.status;
        this.expireAtInMillis = builder.expireAtInMillis;
        this.sliceCount = builder.sliceCount;
    }

    @JsonProperty(value="jobAgent")
    @Nullable
    public String jobAgent() {
        return this.jobAgent;
    }

    @JsonProperty(value="secrets")
    @Nullable
    public RestoreJobSecrets secrets() {
        return this.secrets;
    }

    @JsonProperty(value="status")
    @Nullable
    public RestoreJobStatus status() {
        return this.status;
    }

    @JsonProperty(value="expireAt")
    @Nullable
    public Long expireAtInMillis() {
        return this.expireAtInMillis;
    }

    @JsonProperty(value="sliceCount")
    @Nullable
    public Long sliceCount() {
        return this.sliceCount;
    }

    public Date expireAtAsDate() {
        return this.expireAtInMillis == null ? null : new Date(this.expireAtInMillis);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.jobAgent == null && this.secrets == null && this.status == null && this.expireAtInMillis == null && this.sliceCount == null;
    }

    public String toString() {
        return "UpdateRestoreJobRequest{jobAgent='" + this.jobAgent + "', status='" + String.valueOf((Object)this.status) + "', secrets='" + String.valueOf(this.secrets) + "', expireAt='" + this.expireAtInMillis + "', sliceCount='" + this.sliceCount + "'}";
    }

    public static class Builder
    implements DataObjectBuilder<Builder, UpdateRestoreJobRequestPayload> {
        private String jobAgent;
        private RestoreJobSecrets secrets;
        private RestoreJobStatus status;
        private Long expireAtInMillis;
        private Long sliceCount;

        public Builder withJobAgent(String jobAgent) {
            return this.update(b -> {
                b.jobAgent = jobAgent;
            });
        }

        public Builder withSecrets(RestoreJobSecrets secrets) {
            return this.update(b -> {
                b.secrets = secrets;
            });
        }

        public Builder withStatus(RestoreJobStatus status) {
            return this.update(b -> {
                b.status = status;
            });
        }

        public Builder withExpireAtInMillis(Long expireAtInMillis) {
            return this.update(b -> {
                b.expireAtInMillis = expireAtInMillis;
            });
        }

        public Builder withSliceCount(Long sliceCount) {
            return this.update(b -> {
                b.sliceCount = sliceCount;
            });
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public UpdateRestoreJobRequestPayload build() {
            return new UpdateRestoreJobRequestPayload(this);
        }
    }
}

