/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TokenRange
implements Serializable {
    private static final long serialVersionUID = 6367860484115802919L;
    @NotNull
    private final BigInteger lowerBound;
    private final BigInteger firstEnclosedValue;
    @NotNull
    private final BigInteger upperBound;

    private TokenRange(@NotNull BigInteger lowerBound, @NotNull BigInteger upperBound) {
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("The lower bound cannot be greater than the upper bound to compose a TokenRange. lowerBound: " + String.valueOf(lowerBound) + "; upperBound: " + String.valueOf(upperBound));
        }
        this.lowerBound = lowerBound;
        this.firstEnclosedValue = lowerBound.add(BigInteger.ONE);
        this.upperBound = upperBound;
    }

    @NotNull
    public BigInteger lowerEndpoint() {
        return this.lowerBound;
    }

    @NotNull
    public BigInteger upperEndpoint() {
        return this.upperBound;
    }

    @NotNull
    public BigInteger firstEnclosedValue() {
        return this.firstEnclosedValue;
    }

    @NotNull
    public static TokenRange singleton(@NotNull BigInteger value) {
        return new TokenRange(value.subtract(BigInteger.ONE), value);
    }

    @NotNull
    public static TokenRange closed(@NotNull BigInteger lower, @NotNull BigInteger upper) {
        return new TokenRange(lower.subtract(BigInteger.ONE), upper);
    }

    @NotNull
    public static TokenRange openClosed(@NotNull BigInteger lower, @NotNull BigInteger upper) {
        return new TokenRange(lower, upper);
    }

    @NotNull
    public static TokenRange merge(@NotNull TokenRange first, @NotNull TokenRange second) {
        return first.span(second);
    }

    public boolean isEmpty() {
        return this.upperBound.compareTo(this.lowerBound) == 0;
    }

    public BigInteger size() {
        return this.upperBound.subtract(this.lowerBound);
    }

    public boolean contains(@NotNull BigInteger value) {
        return value.compareTo(this.lowerBound) > 0 && value.compareTo(this.upperBound) <= 0;
    }

    public boolean encloses(@NotNull TokenRange other) {
        return other.lowerBound.compareTo(this.lowerBound) >= 0 && other.upperBound.compareTo(this.upperBound) <= 0;
    }

    public boolean isConnected(@NotNull TokenRange other) {
        return this.lowerBound.compareTo(other.upperBound) < 0 && this.upperBound.compareTo(other.lowerBound) > 0;
    }

    @NotNull
    public TokenRange intersection(@NotNull TokenRange other) {
        return new TokenRange(this.lowerBound.max(other.lowerBound), this.upperBound.min(other.upperBound));
    }

    @NotNull
    public TokenRange span(@NotNull TokenRange other) {
        return new TokenRange(this.lowerBound.min(other.lowerBound), this.upperBound.max(other.upperBound));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenRange that = (TokenRange)o;
        return Objects.equals(this.lowerBound, that.lowerBound) && Objects.equals(this.upperBound, that.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    @NotNull
    public String toString() {
        return "(" + String.valueOf(this.lowerBound) + ", " + String.valueOf(this.upperBound) + "]";
    }
}

