/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.cassandra.cdc.avro.AvroSchemas;

public final class AvroDataUtils {
    private static final Conversions.DecimalConversion decimalConversions = new Conversions.DecimalConversion();

    private AvroDataUtils() {
    }

    public static Object toAvro(Object cassandraValue, Schema fieldSchema) {
        if (cassandraValue instanceof Byte) {
            return (int)((Byte)cassandraValue).byteValue();
        }
        if (cassandraValue instanceof Short) {
            return (int)((Short)cassandraValue).shortValue();
        }
        if (cassandraValue instanceof InetAddress) {
            return ByteBuffer.wrap(((InetAddress)cassandraValue).getAddress());
        }
        if (cassandraValue instanceof Date) {
            Date date = (Date)cassandraValue;
            return TimeUnit.MILLISECONDS.toMicros(date.getTime());
        }
        if (cassandraValue instanceof Map) {
            Map map = (Map)cassandraValue;
            Schema unwrapped = AvroSchemas.unwrapNullable((Schema)fieldSchema);
            if (AvroSchemas.isRecordBasedUdt((Schema)unwrapped)) {
                GenericData.Record udtEntry = new GenericData.Record(unwrapped);
                map.forEach((key, value) -> {
                    String fieldName = key.toString();
                    udtEntry.put(fieldName, AvroDataUtils.toAvro(value, unwrapped.getField(fieldName).schema()));
                });
                return udtEntry;
            }
            return map.entrySet().stream().map(entry -> {
                Schema mapEntrySchema = unwrapped.getElementType();
                GenericData.Record mapEntry = new GenericData.Record(mapEntrySchema);
                mapEntry.put("key", AvroDataUtils.toAvro(entry.getKey(), mapEntrySchema.getField("key").schema()));
                mapEntry.put("value", AvroDataUtils.toAvro(entry.getValue(), mapEntrySchema.getField("value").schema()));
                return mapEntry;
            }).collect(Collectors.toList());
        }
        if (cassandraValue instanceof Collection) {
            Schema elementSchema = AvroSchemas.unwrapNullable((Schema)fieldSchema).getElementType();
            return ((Collection)cassandraValue).stream().map(value -> AvroDataUtils.toAvro(value, elementSchema)).collect(Collectors.toList());
        }
        if (cassandraValue instanceof UUID) {
            return cassandraValue.toString();
        }
        if (cassandraValue instanceof BigInteger) {
            Schema schema = AvroSchemas.unwrapNullable((Schema)fieldSchema);
            return decimalConversions.toFixed(new BigDecimal((BigInteger)cassandraValue), schema, schema.getLogicalType());
        }
        if (cassandraValue instanceof BigDecimal) {
            Schema schema = AvroSchemas.unwrapNullable((Schema)fieldSchema);
            return decimalConversions.toFixed((BigDecimal)cassandraValue, schema, schema.getLogicalType());
        }
        return cassandraValue;
    }

    public static byte[] encode(GenericDatumWriter<GenericRecord> writer, GenericData.Record update, BinaryEncoder encoder) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)out, encoder);
        try {
            writer.write((Object)update, (Encoder)binaryEncoder);
            binaryEncoder.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }
}

