/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.movement;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.analytics.movement.NodeMovementTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class NodeMovementMultiDCTest
extends NodeMovementTestBase {
    NodeMovementMultiDCTest() {
    }

    @ParameterizedTest(name="{index} => {0}")
    @MethodSource(value={"multiDCTestInputs"})
    void testMoveNodeMultiDC(TestConsistencyLevel cl) {
        this.runMovingNodeTest(cl);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3_DC2_RF3);
        NodeMovementMultiDCTest.multiDCTestInputs().forEach(arguments -> {
            QualifiedName tableName = NodeMovementMultiDCTest.uniqueTestTableFullName("spark_test", arguments.get());
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperMovingNodeMultiDC.transitioningStateStart;
    }

    protected void beforeClusterShutdown() {
        this.completeTransitionAndValidateWrites(BBHelperMovingNodeMultiDC.transitioningStateEnd, NodeMovementMultiDCTest.multiDCTestInputs(), false);
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return NodeMovementMultiDCTest.clusterConfig().nodesPerDc(3).dcCount(2).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperMovingNodeMultiDC::install);
    }

    static Stream<Arguments> multiDCTestInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.QUORUM, ConsistencyLevel.QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ONE, ConsistencyLevel.ALL)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ALL, ConsistencyLevel.ONE)}));
    }

    public static class BBHelperMovingNodeMultiDC {
        static final CountDownLatch transitioningStateStart = new CountDownLatch(1);
        static final CountDownLatch transitioningStateEnd = new CountDownLatch(1);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber == 3) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.RangeRelocator").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"stream")).intercept((Implementation)MethodDelegation.to(BBHelperMovingNodeMultiDC.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static Future<?> stream(@SuperCall Callable<Future<?>> orig) throws Exception {
            Future<?> res = orig.call();
            transitioningStateStart.countDown();
            TestUninterruptibles.awaitUninterruptiblyOrThrow(transitioningStateEnd, 2L, TimeUnit.MINUTES);
            return res;
        }
    }
}

