/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.applib.value;

import java.util.Random;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.apache.causeway.applib.value.NamedWithMimeType.CommonMimeType;

class Blob_zip_Test {

    private byte[] bytes;

    @BeforeEach
    void setup() {
        var rd = new Random(9999); // fixed seed - reproducible tests
        this.bytes = new byte[16*1024];
        rd.nextBytes(bytes);
    }

    @Test
    void zipUnzipRountripOnBlob() throws Exception {
        var blob = Blob.of("name", CommonMimeType.BIN, bytes);
        assertEquals(blob, blob.zip().unZip(CommonMimeType.BIN));
    }

}
