/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog.meta;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.commitlog.CommitLog;
import org.apache.cayenne.commitlog.meta.CommitLogEntity;
import org.apache.cayenne.commitlog.meta.CommitLogEntityFactory;
import org.apache.cayenne.commitlog.meta.MutableCommitLogLogEntity;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

public class AnnotationCommitLogEntityFactory
implements CommitLogEntityFactory {
    private static final CommitLogEntity BLOCKED_ENTITY = new CommitLogEntity(){

        @Override
        public boolean isIncluded(String property) {
            return false;
        }

        @Override
        public boolean isConfidential(String property) {
            return false;
        }

        @Override
        public boolean isIncluded() {
            return false;
        }
    };
    private Provider<DataChannel> channelProvider;
    private ConcurrentMap<String, CommitLogEntity> entities = new ConcurrentHashMap<String, CommitLogEntity>();

    public AnnotationCommitLogEntityFactory(@Inject Provider<DataChannel> channelProvider) {
        this.channelProvider = channelProvider;
    }

    @Override
    public CommitLogEntity getEntity(ObjectId id) {
        String entityName = id.getEntityName();
        CommitLogEntity descriptor = (CommitLogEntity)this.entities.get(entityName);
        if (descriptor == null) {
            CommitLogEntity newDescriptor = this.createDescriptor(entityName);
            CommitLogEntity existingDescriptor = this.entities.putIfAbsent(entityName, newDescriptor);
            descriptor = existingDescriptor != null ? existingDescriptor : newDescriptor;
        }
        return descriptor;
    }

    private EntityResolver getEntityResolver() {
        return ((DataChannel)this.channelProvider.get()).getEntityResolver();
    }

    private CommitLogEntity createDescriptor(String entityName) {
        EntityResolver entityResolver = this.getEntityResolver();
        ClassDescriptor classDescriptor = entityResolver.getClassDescriptor(entityName);
        CommitLog a = classDescriptor.getObjectClass().getAnnotation(CommitLog.class);
        if (a == null) {
            return BLOCKED_ENTITY;
        }
        ObjEntity entity = entityResolver.getObjEntity(entityName);
        return new MutableCommitLogLogEntity(entity).setConfidential(a.confidential()).setIgnoreProperties(a.ignoredProperties()).setIgnoreAttributes(a.ignoreAttributes()).setIgnoreToOneRelationships(a.ignoreToOneRelationships()).setIgnoreToManyRelationships(a.ignoreToManyRelationships());
    }
}

