/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.fileupload2.core.DeferrableOutputStream;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.file.PathUtils;

public final class DiskFileItem
implements FileItem<DiskFileItem> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final String UID = UUID.randomUUID().toString().replace('-', '_');
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private String fieldName;
    private final String contentType;
    private volatile boolean isFormField;
    private final String fileName;
    private final int threshold;
    private final Path repository;
    private DeferrableOutputStream dos;
    private FileItemHeaders fileItemHeaders;
    private Charset charsetDefault = DEFAULT_CHARSET;
    private FileCleaningTracker fileCleaningTracker;

    public static Builder builder() {
        return new Builder();
    }

    public static String checkFileName(String fileName) {
        if (fileName != null) {
            int indexOf0 = fileName.indexOf(0);
            if (indexOf0 != -1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < fileName.length(); ++i) {
                    char c = fileName.charAt(i);
                    if (c == '\u0000') {
                        sb.append("\\0");
                        continue;
                    }
                    sb.append(c);
                }
                throw new InvalidPathException(fileName, sb.toString(), indexOf0);
            }
            Paths.get(fileName, new String[0]);
        }
        return fileName;
    }

    private static String getUniqueId() {
        int limit = 100000000;
        int current = COUNTER.getAndIncrement();
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    private DiskFileItem(Builder builder) {
        this.fieldName = builder.getFieldName();
        this.contentType = builder.getContentType();
        this.charsetDefault = builder.getCharset();
        this.isFormField = builder.isFormField();
        this.fileName = builder.getFileName();
        this.fileItemHeaders = builder.getFileItemHeaders();
        this.threshold = builder.getThreshold();
        this.repository = builder.getPath() != null ? builder.getPath() : PathUtils.getTempDirectory();
    }

    @Override
    public DiskFileItem delete() throws IOException {
        Path path;
        if (this.dos != null && (path = this.dos.getPath()) != null) {
            Files.deleteIfExists(path);
        }
        return this;
    }

    @Override
    public byte[] get() throws IOException {
        if (this.dos != null) {
            byte[] bytes = this.dos.getBytes();
            if (bytes != null) {
                return bytes;
            }
            Path path = this.dos.getPath();
            if (path != null && this.dos.getState() == DeferrableOutputStream.State.closed) {
                return Files.readAllBytes(path);
            }
        }
        return null;
    }

    public Charset getCharset() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        return Charsets.toCharset((String)params.get("charset"), (Charset)this.charsetDefault);
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public FileCleaningTracker getFileCleaningTracker() {
        return this.fileCleaningTracker;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.fileItemHeaders;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.dos != null && this.dos.getState() == DeferrableOutputStream.State.closed) {
            return this.dos.getInputStream();
        }
        throw new IllegalStateException("The file item has not been fully read.");
    }

    @Override
    public String getName() {
        return DiskFileItem.checkFileName(this.fileName);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.dos == null) {
            Supplier<Path> pathSupplier = () -> this.repository.resolve(String.format("upload_%s_%s.tmp", UID, DiskFileItem.getUniqueId()));
            try {
                DeferrableOutputStream.Listener persistenceListener = new DeferrableOutputStream.Listener(){

                    @Override
                    public void persisted(Path pPath) {
                        DeferrableOutputStream.Listener.super.persisted(pPath);
                        FileCleaningTracker fct = DiskFileItem.this.getFileCleaningTracker();
                        if (fct != null) {
                            fct.track(DiskFileItem.this.getPath(), (Object)this);
                        }
                    }
                };
                this.dos = new DeferrableOutputStream(this.threshold, pathSupplier, persistenceListener);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        return this.dos;
    }

    public Path getPath() {
        return this.dos == null ? null : this.dos.getPath();
    }

    public Reader getReader() throws IOException, UnsupportedEncodingException {
        InputStream is = this.getInputStream();
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        Charset cs = Charsets.toCharset((String)params.get("charset"), (Charset)this.charsetDefault);
        return new InputStreamReader(is, cs);
    }

    @Override
    public long getSize() {
        return this.dos == null ? 0L : this.dos.getSize();
    }

    @Override
    public String getString() throws IOException, UnsupportedEncodingException, OutOfMemoryError {
        byte[] bytes = this.get();
        return bytes == null ? null : new String(bytes, this.getCharset());
    }

    @Override
    public String getString(Charset charset) throws IOException {
        return new String(this.get(), Charsets.toCharset((Charset)charset, (Charset)this.charsetDefault));
    }

    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public boolean isInMemory() {
        return this.dos == null || this.dos.isInMemory();
    }

    public DiskFileItem setCharsetDefault(Charset charset) {
        this.charsetDefault = charset;
        return this;
    }

    @Override
    public DiskFileItem setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public void setFileCleaningTracker(FileCleaningTracker fileCleaningTracker) {
        this.fileCleaningTracker = fileCleaningTracker;
    }

    @Override
    public DiskFileItem setFormField(boolean state) {
        this.isFormField = state;
        return this;
    }

    @Override
    public DiskFileItem setHeaders(FileItemHeaders headers) {
        this.fileItemHeaders = headers;
        return this;
    }

    public String toString() {
        return String.format("name=%s, StoreLocation=%s, size=%s bytes, isFormField=%s, FieldName=%s", this.getName(), this.getPath(), this.getSize(), this.isFormField(), this.getFieldName());
    }

    @Override
    public DiskFileItem write(Path file) throws IOException {
        block10: {
            if (this.isInMemory()) {
                try (OutputStream fout = Files.newOutputStream(file, new OpenOption[0]);){
                    fout.write(this.get());
                    break block10;
                }
                catch (IOException e) {
                    throw new IOException("Unexpected output data", e);
                }
            }
            Path outputFile = this.getPath();
            if (outputFile == null) {
                throw new FileUploadException("Cannot write uploaded file to disk.");
            }
            Files.move(outputFile, file, StandardCopyOption.REPLACE_EXISTING);
        }
        return this;
    }

    public static class Builder
    extends FileItemFactory.AbstractFileItemBuilder<DiskFileItem, Builder> {
        private int threshold;

        public Builder() {
            this.setBufferSize(10240);
            this.setPath(PathUtils.getTempDirectory());
            this.setCharset(DEFAULT_CHARSET);
            this.setCharsetDefault(DEFAULT_CHARSET);
        }

        public DiskFileItem get() {
            DiskFileItem diskFileItem = new DiskFileItem(this);
            FileCleaningTracker tracker = this.getFileCleaningTracker();
            if (tracker != null) {
                diskFileItem.setFileCleaningTracker(tracker);
            }
            return diskFileItem;
        }

        public int getBufferSize() {
            return this.getThreshold();
        }

        public int getThreshold() {
            return this.threshold;
        }

        public Builder setBufferSize(int bufferSize) {
            return this.setThreshold(bufferSize);
        }

        public Builder setThreshold(int threshold) {
            this.threshold = threshold;
            return this;
        }
    }
}

