/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Debugger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SwitchTest
extends JexlTestCase {
    public SwitchTest() {
        super("SwitchTest");
    }

    @Test
    void testSwitchExpression() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        JexlScript e = jexl.createScript("var j = switch(i) { case 1 -> 2; case 2 -> 3; default -> 4; }; j", new String[]{"i"});
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc, new Object[]{1});
        Assertions.assertEquals((Object)2, (Object)o);
    }

    @Test
    void testBrokenSwitchExpression0() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        try {
            jexl.createScript("var j = switch(i) { case 1 -> return 2;  }; j", new String[]{"i"});
            Assertions.fail((String)"should not be able to create script with return in switch expression");
        }
        catch (JexlException.Parsing xparse) {
            Assertions.assertTrue((boolean)xparse.getMessage().contains("return"));
        }
        try {
            jexl.createScript("var j = switch(i) { case 1 -> break; }; j", new String[]{"i"});
            Assertions.fail((String)"should not be able to create script with break in switch expression");
        }
        catch (JexlException.Parsing xparse) {
            Assertions.assertTrue((boolean)xparse.getMessage().contains("break"));
        }
    }

    @Test
    void testSwitchStatement() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        JexlScript e = jexl.createScript("switch(i) { case 1: i += 2; case 2: i += 3; default: i += 4; }; i + 33", new String[]{"i"});
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc, new Object[]{2});
        Assertions.assertEquals((Object)42, (Object)o);
    }

    @Test
    void test440a() {
        JexlFeatures f = JexlFeatures.createDefault().ambiguousStatement(true);
        JexlEngine jexl = new JexlBuilder().features(f).safe(false).strict(true).create();
        String src = "let y = switch (x) { case 10,11 -> 3 case 20, 21 -> 4\ndefault -> { let z = 4; z + x } } y";
        JexlScript script = jexl.createScript(src, new String[]{"x"});
        Assertions.assertNotNull((Object)script);
        String dbgStr = script.getParsedText();
        Assertions.assertNotNull((Object)dbgStr);
        Object result = script.execute(null, new Object[]{10});
        Assertions.assertEquals((Object)3, (Object)result);
        result = script.execute(null, new Object[]{11});
        Assertions.assertEquals((Object)3, (Object)result);
        result = script.execute(null, new Object[]{20});
        Assertions.assertEquals((Object)4, (Object)result);
        result = script.execute(null, new Object[]{21});
        Assertions.assertEquals((Object)4, (Object)result);
        result = script.execute(null, new Object[]{38});
        Assertions.assertEquals((Object)42, (Object)result);
        src = "let y = switch (x) { case 10,11 -> break; case 20, 21 -> 4; } y";
        try {
            script = jexl.createScript(src, new String[]{"x"});
            Assertions.fail((String)"should not be able to create script with break in switch");
        }
        catch (JexlException.Parsing xparse) {
            Assertions.assertTrue((boolean)xparse.getMessage().contains("break"));
        }
        Assertions.assertNotNull((Object)script);
    }

    @Test
    void test440b() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        String src = "switch (x) {\n case 10 : return 3\n; case 20 : case 21 : return 4;\n case 32: break; \n default : return x + 4;\n }\n 169";
        JexlScript script = jexl.createScript("switch (x) {\n case 10 : return 3\n; case 20 : case 21 : return 4;\n case 32: break; \n default : return x + 4;\n }\n 169", new String[]{"x"});
        Assertions.assertNotNull((Object)script);
        String dbgStr = script.getParsedText();
        Assertions.assertNotNull((Object)dbgStr);
        Object result = script.execute(null, new Object[]{10});
        Assertions.assertEquals((Object)3, (Object)result);
        result = script.execute(null, new Object[]{20});
        Assertions.assertEquals((Object)4, (Object)result);
        result = script.execute(null, new Object[]{21});
        Assertions.assertEquals((Object)4, (Object)result);
        result = script.execute(null, new Object[]{32});
        Assertions.assertEquals((Object)169, (Object)result);
        result = script.execute(null, new Object[]{38});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test440c() {
        JexlEngine jexl = new JexlBuilder().loader(this.getClass().getClassLoader()).imports(new String[]{this.getClass().getName()}).create();
        String src = "let s = switch (x) { case Scope440.UNDEFINED -> 'undefined'; case Scope440.THIS -> 'this'; default -> 'OTHER'; } s";
        JexlScript script = jexl.createScript("let s = switch (x) { case Scope440.UNDEFINED -> 'undefined'; case Scope440.THIS -> 'this'; default -> 'OTHER'; } s", new String[]{"x"});
        Assertions.assertNotNull((Object)script);
        String dbgStr = script.getParsedText();
        Assertions.assertNotNull((Object)dbgStr);
        Object result = script.execute(null, new Object[]{Scope440.UNDEFINED});
        Assertions.assertEquals((Object)"undefined", (Object)result);
        result = script.execute(null, new Object[]{Scope440.THIS});
        Assertions.assertEquals((Object)"this", (Object)result);
        result = script.execute(null, new Object[]{21});
        Assertions.assertEquals((Object)"OTHER", (Object)result);
    }

    @Test
    void test440d() {
        JexlEngine jexl = new JexlBuilder().loader(this.getClass().getClassLoader()).imports(new String[]{this.getClass().getName()}).create();
        String src = "let s = switch (x) { case Scope440.UNDEFINED -> 'undefined'; } s";
        JexlScript script = jexl.createScript("let s = switch (x) { case Scope440.UNDEFINED -> 'undefined'; } s", new String[]{"x"});
        try {
            script.execute(null, new Object[]{Scope440.THIS});
            Assertions.fail((String)"should not be able to execute script with switch expression with no default");
        }
        catch (JexlException xjexl) {
            Assertions.assertTrue((boolean)xjexl.getMessage().contains("switch"));
        }
    }

    @Test
    void test440e() {
        JexlEngine jexl = new JexlBuilder().loader(this.getClass().getClassLoader()).imports(new String[]{this.getClass().getName()}).create();
        String src = "function f(x) { switch (x) { case Scope440.UNDEFINED : return 'undefined'; } } f(x)";
        JexlScript script = jexl.createScript("function f(x) { switch (x) { case Scope440.UNDEFINED : return 'undefined'; } } f(x)", new String[]{"x"});
        Object result = script.execute(null, new Object[]{Scope440.UNDEFINED});
        Assertions.assertEquals((Object)"undefined", (Object)result);
        try {
            script.execute(null, new Object[]{Scope440.THIS});
            Assertions.fail((String)"should not be able to execute script with switch expression with no default");
        }
        catch (JexlException xjexl) {
            Assertions.assertTrue((boolean)xjexl.getMessage().contains("switch"));
        }
    }

    @Test
    void testSwitchStatement1() {
        String src = "switch (x) {\n  case 1: return 'one';\n  case 2: return 'two';\n  case 3: return 'three';\n  default: return 'many';\n}";
        this.runSwitch("switch (x) {\n  case 1: return 'one';\n  case 2: return 'two';\n  case 3: return 'three';\n  default: return 'many';\n}");
        String src2 = "if (true) { switch (x) {\n  case 1: return 'one';\n  case 2: return 'two';\n  case 3: return 'three';\n  default: return 'many';\n} }";
        this.runSwitch("if (true) { switch (x) {\n  case 1: return 'one';\n  case 2: return 'two';\n  case 3: return 'three';\n  default: return 'many';\n} }");
    }

    @Test
    void testSwitchExpression1() {
        String src = "switch (x) {\n  case 1 -> 'one';\n  case 2 -> 'two';\n  case 3 -> 'three';\n  default -> 'many';\n}";
        this.runSwitch("switch (x) {\n  case 1 -> 'one';\n  case 2 -> 'two';\n  case 3 -> 'three';\n  default -> 'many';\n}");
        String src2 = "if (true) { switch (x) {\n  case 1 -> 'one';\n  case 2 -> 'two';\n  case 3 -> 'three';\n  default -> 'many';\n} }";
        this.runSwitch("if (true) { switch (x) {\n  case 1 -> 'one';\n  case 2 -> 'two';\n  case 3 -> 'three';\n  default -> 'many';\n} }");
    }

    void runSwitch(String src) {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript(src, new String[]{"x"});
        Object result = script.execute(null, new Object[]{1});
        Assertions.assertEquals((Object)"one", (Object)result);
        result = script.execute(null, new Object[]{2});
        Assertions.assertEquals((Object)"two", (Object)result);
        result = script.execute(null, new Object[]{3});
        Assertions.assertEquals((Object)"three", (Object)result);
        result = script.execute(null, new Object[]{4});
        Assertions.assertEquals((Object)"many", (Object)result);
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"many", (Object)result);
        Debugger debugger = new Debugger();
        Assertions.assertTrue((boolean)debugger.debug(script));
        String dbgStr = debugger.toString();
        Assertions.assertTrue((boolean)JexlTestCase.equalsIgnoreWhiteSpace(src, dbgStr));
    }

    @Test
    void testSwitchExpressionFail() {
        List<String> err = Arrays.asList("break", "continue");
        for (String keyword : err) {
            this.switchExpressionFailKeyword(keyword);
        }
    }

    private void switchExpressionFailKeyword(String keyword) {
        String src = "switch (x) {\n  case 1 -> 'one';\n  case 2 -> " + keyword + ";\n  default -> 'many';\n}";
        JexlEngine jexl = new JexlBuilder().create();
        try {
            jexl.createScript(src, new String[]{"x"});
            Assertions.fail((String)("should not be able to create script with " + keyword + " in switch expression"));
        }
        catch (JexlException.Parsing xparse) {
            Assertions.assertTrue((boolean)xparse.getMessage().contains(keyword));
        }
    }

    public static enum Scope440 {
        UNDEFINED,
        UNDECLARED,
        GLOBAL,
        LOCAL,
        THIS,
        SUPER;

    }
}

