/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jexl3.internal.introspection.ClassMap;
import org.apache.commons.jexl3.internal.introspection.MethodKey;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.logging.Log;

public final class Introspector {
    private static final Constructor<?> CTOR_MISS = CacheMiss.class.getConstructors()[0];
    private final Log logger;
    private final JexlPermissions permissions;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Class<?>, ClassMap> classMethodMaps = new HashMap();
    private final Map<MethodKey, Constructor<?>> constructorsMap = new HashMap();
    private final Map<String, Class<?>> constructibleClasses = new HashMap();
    private volatile ClassLoader loader;

    private static boolean isLoadedBy(ClassLoader loader, Class<?> clazz) {
        if (loader != null) {
            for (ClassLoader cloader = clazz.getClassLoader(); cloader != null; cloader = cloader.getParent()) {
                if (!cloader.equals(loader)) continue;
                return true;
            }
        }
        return false;
    }

    public Introspector(Log log, ClassLoader cloader) {
        this(log, cloader, null);
    }

    public Introspector(Log log, ClassLoader loader, JexlPermissions perms) {
        this.logger = log;
        this.loader = loader != null ? loader : JexlUberspect.class.getClassLoader();
        this.permissions = perms == null ? JexlPermissions.RESTRICTED : perms;
    }

    public Class<?> getClassByName(String className) {
        try {
            ClassLoader classLoader = this.loader;
            Class<?> clazz = Class.forName(className, false, classLoader);
            return this.permissions.allow(clazz) ? clazz : null;
        }
        catch (ClassNotFoundException xignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor<?> getConstructor(Class<?> c, MethodKey key) {
        Constructor<?> ctor;
        this.lock.readLock().lock();
        try {
            ctor = this.constructorsMap.get(key);
            if (ctor != null) {
                Constructor<?> constructor = CTOR_MISS.equals(ctor) ? null : ctor;
                return constructor;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            ctor = this.constructorsMap.get(key);
            if (ctor != null) {
                Constructor<?> constructor = CTOR_MISS.equals(ctor) ? null : ctor;
                return constructor;
            }
            String constructorName = key.getMethod();
            Class<?> clazz = this.constructibleClasses.get(constructorName);
            try {
                if (clazz == null) {
                    clazz = c != null && c.getName().equals(key.getMethod()) ? c : this.loader.loadClass(constructorName);
                    this.constructibleClasses.put(constructorName, clazz);
                }
                ArrayList constructors = new ArrayList();
                for (Constructor<?> ictor : clazz.getConstructors()) {
                    if (!this.permissions.allow(ictor)) continue;
                    constructors.add(ictor);
                }
                ctor = key.getMostSpecificConstructor(constructors.toArray(new Constructor[0]));
                if (ctor != null) {
                    this.constructorsMap.put(key, ctor);
                } else {
                    this.constructorsMap.put(key, CTOR_MISS);
                }
            }
            catch (ClassNotFoundException xnotfound) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("unable to find class: " + constructorName + "." + key.debugString()), (Throwable)xnotfound);
                }
            }
            catch (MethodKey.AmbiguousException xambiguous) {
                if (this.logger != null && xambiguous.isSevere() && this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("ambiguous constructor invocation: " + constructorName + "." + key.debugString()), (Throwable)xambiguous);
                }
                ctor = null;
            }
            Constructor<?> constructor = ctor;
            return constructor;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Constructor<?> getConstructor(MethodKey key) {
        return this.getConstructor(null, key);
    }

    public Field getField(Class<?> c, String key) {
        return this.getMap(c).getField(key);
    }

    public String[] getFieldNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getFieldNames();
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassMap getMap(Class<?> c) {
        ClassMap classMap;
        this.lock.readLock().lock();
        try {
            classMap = this.classMethodMaps.get(c);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (classMap == null) {
            this.lock.writeLock().lock();
            try {
                classMap = this.classMethodMaps.get(c);
                if (classMap == null) {
                    classMap = this.permissions.allow(c) ? new ClassMap(c, this.permissions, this.logger) : ClassMap.empty();
                    this.classMethodMaps.put(c, classMap);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return classMap;
    }

    public Method getMethod(Class<?> c, MethodKey key) {
        try {
            return this.getMap(c).getMethod(key);
        }
        catch (MethodKey.AmbiguousException xambiguous) {
            if (this.logger != null && xambiguous.isSevere() && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("ambiguous method invocation: " + c.getName() + "." + key.debugString()), (Throwable)xambiguous);
            }
            return null;
        }
    }

    public Method getMethod(Class<?> c, String name, Object ... params) {
        return this.getMethod(c, new MethodKey(name, params));
    }

    public String[] getMethodNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getMethodNames();
    }

    public Method[] getMethods(Class<?> c, String methodName) {
        if (c == null) {
            return null;
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getMethods(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader classLoader) {
        ClassLoader current = classLoader == null ? JexlUberspect.class.getClassLoader() : classLoader;
        this.lock.writeLock().lock();
        try {
            ClassLoader previous = this.loader;
            if (!current.equals(previous)) {
                Iterator<Map.Entry<MethodKey, Constructor<?>>> constructors = this.constructorsMap.entrySet().iterator();
                while (constructors.hasNext()) {
                    Map.Entry<MethodKey, Constructor<?>> entry = constructors.next();
                    Class<?> clazz = entry.getValue().getDeclaringClass();
                    if (!Introspector.isLoadedBy(previous, clazz)) continue;
                    constructors.remove();
                    if (CTOR_MISS.equals(entry.getValue())) continue;
                    this.constructibleClasses.remove(entry.getKey().getMethod());
                }
                Iterator<Map.Entry<Class<?>, ClassMap>> methods = this.classMethodMaps.entrySet().iterator();
                while (methods.hasNext()) {
                    Map.Entry<Class<?>, ClassMap> entry = methods.next();
                    Class<?> clazz = entry.getKey();
                    if (!Introspector.isLoadedBy(previous, clazz)) continue;
                    methods.remove();
                }
                this.loader = current;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static final class CacheMiss {
    }
}

