/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.server.plugin.impl.LoggingActiveMQServerPluginLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingActiveMQServerPlugin
implements ActiveMQServerPlugin,
Serializable {
    public static final String LOG_ALL_EVENTS = "LOG_ALL_EVENTS";
    public static final String LOG_CONNECTION_EVENTS = "LOG_CONNECTION_EVENTS";
    public static final String LOG_SESSION_EVENTS = "LOG_SESSION_EVENTS";
    public static final String LOG_CONSUMER_EVENTS = "LOG_CONSUMER_EVENTS";
    public static final String LOG_DELIVERING_EVENTS = "LOG_DELIVERING_EVENTS";
    public static final String LOG_SENDING_EVENTS = "LOG_SENDING_EVENTS";
    public static final String LOG_INTERNAL_EVENTS = "LOG_INTERNAL_EVENTS";
    public static final String UNAVAILABLE = "UNAVAILABLE";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    private boolean logAll = false;
    private boolean logConnectionEvents = false;
    private boolean logSessionEvents = false;
    private boolean logConsumerEvents = false;
    private boolean logDeliveringEvents = false;
    private boolean logSendingEvents = false;
    private boolean logInternalEvents = false;

    public boolean isLogAll() {
        return this.logAll;
    }

    public boolean isLogConnectionEvents() {
        return this.logConnectionEvents;
    }

    public boolean isLogSessionEvents() {
        return this.logSessionEvents;
    }

    public boolean isLogConsumerEvents() {
        return this.logConsumerEvents;
    }

    public boolean isLogDeliveringEvents() {
        return this.logDeliveringEvents;
    }

    public boolean isLogSendingEvents() {
        return this.logSendingEvents;
    }

    public boolean isLogInternalEvents() {
        return this.logInternalEvents;
    }

    @Override
    public void init(Map<String, String> properties) {
        this.logAll = Boolean.parseBoolean(properties.getOrDefault(LOG_ALL_EVENTS, "false"));
        this.logConnectionEvents = Boolean.parseBoolean(properties.getOrDefault(LOG_CONNECTION_EVENTS, "false"));
        this.logSessionEvents = Boolean.parseBoolean(properties.getOrDefault(LOG_SESSION_EVENTS, "false"));
        this.logConsumerEvents = Boolean.parseBoolean(properties.getOrDefault(LOG_CONSUMER_EVENTS, "false"));
        this.logDeliveringEvents = Boolean.parseBoolean(properties.getOrDefault(LOG_DELIVERING_EVENTS, "false"));
        this.logSendingEvents = Boolean.parseBoolean(properties.getOrDefault(LOG_SENDING_EVENTS, "false"));
        this.logInternalEvents = Boolean.parseBoolean(properties.getOrDefault(LOG_INTERNAL_EVENTS, "false"));
        this.dumpConfiguration();
    }

    @Override
    public void afterCreateConnection(RemotingConnection connection) throws ActiveMQException {
        if (this.logAll || this.logConnectionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterCreateConnection(connection);
        }
    }

    @Override
    public void afterDestroyConnection(RemotingConnection connection) throws ActiveMQException {
        if (this.logAll || this.logConnectionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterDestroyConnection(connection);
        }
    }

    @Override
    public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String publicAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws ActiveMQException {
        if (this.logAll || this.logSessionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeCreateSession(name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, publicAddress);
        }
    }

    @Override
    public void afterCreateSession(ServerSession session) throws ActiveMQException {
        if (this.logAll || this.logSessionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterCreateSession(session == null ? UNAVAILABLE : session.getName(), session == null ? UNAVAILABLE : session.getConnectionID(), this.getRemoteAddress(session));
        }
    }

    private String getRemoteAddress(ServerSession session) {
        if (session == null) {
            return null;
        }
        RemotingConnection remotingConnection = session.getRemotingConnection();
        if (remotingConnection == null) {
            return null;
        }
        return remotingConnection.getRemoteAddress();
    }

    @Override
    public void beforeCloseSession(ServerSession session, boolean failed) throws ActiveMQException {
        if (this.logAll || this.logSessionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeCloseSession(session == null ? UNAVAILABLE : session.getName(), session, failed);
        }
    }

    @Override
    public void afterCloseSession(ServerSession session, boolean failed) throws ActiveMQException {
        if (this.logAll || this.logSessionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterCloseSession(session == null ? UNAVAILABLE : session.getName(), failed, this.getRemoteAddress(session));
        }
    }

    @Override
    public void beforeSessionMetadataAdded(ServerSession session, String key, String data) throws ActiveMQException {
        if (this.logAll || this.logSessionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeSessionMetadataAdded(session == null ? UNAVAILABLE : session.getName(), session, key, data);
        }
    }

    @Override
    public void afterSessionMetadataAdded(ServerSession session, String key, String data) throws ActiveMQException {
        if (this.logAll || this.logSessionEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterSessionMetadataAddedDetails(session == null ? UNAVAILABLE : session.getName(), session, key, data);
            LoggingActiveMQServerPluginLogger.LOGGER.afterSessionMetadataAdded(session == null ? UNAVAILABLE : session.getName(), key, data);
        }
    }

    @Override
    public void beforeCreateConsumer(long consumerID, QueueBinding queueBinding, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) throws ActiveMQException {
        if (this.logAll || this.logConsumerEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeCreateConsumer(Long.toString(consumerID), queueBinding, filterString, browseOnly, supportLargeMessage);
        }
    }

    @Override
    public void afterCreateConsumer(ServerConsumer consumer) throws ActiveMQException {
        if (this.logAll || this.logConsumerEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterCreateConsumer(consumer == null ? UNAVAILABLE : Long.toString(consumer.getID()), consumer == null ? UNAVAILABLE : consumer.getSessionID());
        }
    }

    @Override
    public void beforeCloseConsumer(ServerConsumer consumer, boolean failed) throws ActiveMQException {
        if (this.logAll || this.logConsumerEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeCloseConsumer(consumer, consumer == null ? UNAVAILABLE : consumer.getSessionID(), failed);
        }
    }

    @Override
    public void afterCloseConsumer(ServerConsumer consumer, boolean failed) throws ActiveMQException {
        if (this.logAll || this.logConsumerEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterCloseConsumer(consumer == null ? UNAVAILABLE : Long.toString(consumer.getID()), consumer == null ? UNAVAILABLE : consumer.getSessionID(), failed);
        }
    }

    @Override
    public void beforeCreateQueue(QueueConfiguration queueConfig) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeCreateQueue(queueConfig);
        }
    }

    @Override
    public void afterCreateQueue(Queue queue) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterCreateQueue(queue);
        }
    }

    @Override
    public void beforeDestroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeDestroyQueue(queueName, session, checkConsumerCount, removeConsumers, autoDeleteAddress);
        }
    }

    @Override
    public void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterDestroyQueue(queue, address, session, checkConsumerCount, removeConsumers, autoDeleteAddress);
        }
    }

    @Override
    public void beforeSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
        if (this.logAll || this.logSendingEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeSend(message, tx, session, direct, noAutoCreateQueue);
        }
    }

    @Override
    public void afterSend(ServerSession session, Transaction tx, final Message message, boolean direct, boolean noAutoCreateQueue, final RoutingStatus result) throws ActiveMQException {
        if (this.logAll || this.logDeliveringEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterSendDetails(message, result.toString(), tx, session == null ? UNAVAILABLE : session.getName(), session == null ? UNAVAILABLE : session.getConnectionID().toString(), direct, noAutoCreateQueue);
            if (tx != null) {
                tx.addOperation(new TransactionOperationAbstract(this){
                    final /* synthetic */ LoggingActiveMQServerPlugin this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void afterCommit(Transaction tx) {
                        this.this$0.logSend(tx, message, result);
                    }

                    @Override
                    public void afterRollback(Transaction tx) {
                        LoggingActiveMQServerPluginLogger.LOGGER.rolledBackTransaction(tx, message.toString());
                    }
                });
            } else {
                this.logSend(tx, message, result);
            }
        }
    }

    private void logSend(Transaction tx, Message message, RoutingStatus result) {
        LoggingActiveMQServerPluginLogger.LOGGER.afterSend(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), result, tx == null ? UNAVAILABLE : tx.toString());
    }

    @Override
    public void onSendException(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, Exception e) throws ActiveMQException {
        if (this.logAll || this.logSendingEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.onSendErrorDetails(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), message, session == null ? UNAVAILABLE : session.getName(), tx, session, direct, noAutoCreateQueue);
            LoggingActiveMQServerPluginLogger.LOGGER.onSendError(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), session == null ? UNAVAILABLE : session.getName(), session == null ? UNAVAILABLE : session.getConnectionID().toString(), e);
        }
    }

    @Override
    public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) throws ActiveMQException {
        if (this.logAll || this.logSendingEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeMessageRoute(message, context, direct, rejectDuplicates);
        }
    }

    @Override
    public void afterMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, RoutingStatus result) throws ActiveMQException {
        if (this.logAll || this.logSendingEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterMessageRouteDetails(message, context, direct, rejectDuplicates);
            LoggingActiveMQServerPluginLogger.LOGGER.afterMessageRoute(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), result);
        }
    }

    @Override
    public void onMessageRouteException(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Exception e) throws ActiveMQException {
        if (this.logAll || this.logSendingEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.onMessageRouteErrorDetails(message, context, direct, rejectDuplicates);
            LoggingActiveMQServerPluginLogger.LOGGER.onMessageRouteError(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), e);
        }
    }

    @Override
    public void beforeDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        if (this.logAll || this.logDeliveringEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeDeliver(consumer, reference);
        }
    }

    @Override
    public void afterDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        if (this.logAll || this.logDeliveringEvents) {
            Message message;
            Message message2 = message = reference == null ? null : reference.getMessage();
            if (consumer == null) {
                LoggingActiveMQServerPluginLogger.LOGGER.afterDeliverNoConsumer(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()));
                return;
            }
            LoggingActiveMQServerPluginLogger.LOGGER.afterDeliverDetails(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), consumer.getQueueAddress(), consumer.getQueueName(), consumer.getSessionID(), consumer.getID(), reference, consumer);
            LoggingActiveMQServerPluginLogger.LOGGER.afterDeliver(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), consumer.getQueueAddress(), consumer.getQueueName(), consumer.getSessionID(), consumer.getID());
        }
    }

    @Override
    public void messageExpired(MessageReference message, SimpleString messageExpiryAddress, ServerConsumer consumer) {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.messageExpired(message, messageExpiryAddress);
        }
    }

    @Override
    public void messageAcknowledged(Transaction tx, final MessageReference ref, AckReason reason, ServerConsumer consumer) throws ActiveMQException {
        if (this.logAll || this.logDeliveringEvents) {
            Message message = ref == null ? null : ref.getMessage();
            Queue queue = ref == null ? null : ref.getQueue();
            LoggingActiveMQServerPluginLogger.LOGGER.messageAcknowledgedDetails(message == null ? UNAVAILABLE : Long.toString(message.getMessageID()), consumer == null ? UNAVAILABLE : consumer.getSessionID(), consumer == null ? UNAVAILABLE : Long.toString(consumer.getID()), queue == null ? UNAVAILABLE : queue.getName().toString(), tx == null ? UNAVAILABLE : tx.toString(), reason);
            if (tx != null) {
                tx.addOperation(new TransactionOperationAbstract(this){
                    final /* synthetic */ LoggingActiveMQServerPlugin this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void afterCommit(Transaction tx) {
                        this.this$0.logAck(tx, ref);
                    }

                    @Override
                    public void afterRollback(Transaction tx) {
                        LoggingActiveMQServerPluginLogger.LOGGER.rolledBackTransaction(tx, ref.toString());
                    }
                });
            } else {
                this.logAck(tx, ref);
            }
        }
    }

    private void logAck(Transaction tx, MessageReference ref) {
        LoggingActiveMQServerPluginLogger.LOGGER.messageAcknowledged(ref, tx);
    }

    @Override
    public void beforeDeployBridge(BridgeConfiguration config) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.beforeDeployBridge(config);
        }
    }

    @Override
    public void afterDeployBridge(Bridge bridge) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.afterDeployBridge(bridge);
        }
    }

    @Override
    public void criticalFailure(CriticalComponent components) throws ActiveMQException {
        if (this.logAll || this.logInternalEvents) {
            LoggingActiveMQServerPluginLogger.LOGGER.criticalFailure(components);
        }
    }

    private void dumpConfiguration() {
        if (logger.isDebugEnabled()) {
            logger.debug("LoggingPlugin logAll={}", (Object)this.logAll);
            logger.debug("LoggingPlugin logConnectionEvents={}", (Object)this.logConnectionEvents);
            logger.debug("LoggingPlugin logSessionEvents={}", (Object)this.logSessionEvents);
            logger.debug("LoggingPlugin logConsumerEvents={}", (Object)this.logConsumerEvents);
            logger.debug("LoggingPlugin logSendingEvents={}", (Object)this.logSendingEvents);
            logger.debug("LoggingPlugin logDeliveringEvents={}", (Object)this.logDeliveringEvents);
            logger.debug("LoggingPlugin logInternalEvents={}", (Object)this.logInternalEvents);
        }
    }
}

