/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.federation.FederationConnectionConfiguration;

public abstract class FederationStreamConfiguration<T extends FederationStreamConfiguration<T>>
implements Serializable {
    private String name;
    private FederationConnectionConfiguration connectionConfiguration = new FederationConnectionConfiguration();
    private Set<String> policyRefs = new HashSet<String>();

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public Set<String> getPolicyRefs() {
        return this.policyRefs;
    }

    public T setPolicyRefs(Set<String> refs) {
        for (String ref : refs) {
            this.policyRefs.add(ref);
        }
        return (T)this;
    }

    public T addPolicyRef(String name) {
        this.policyRefs.add(name);
        return (T)this;
    }

    public T addPolicyRefs(Collection<String> names) {
        this.policyRefs.addAll(names);
        return (T)this;
    }

    public FederationConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FederationStreamConfiguration)) {
            return false;
        }
        FederationStreamConfiguration other = (FederationStreamConfiguration)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.connectionConfiguration, other.connectionConfiguration) && Objects.equals(this.policyRefs, other.policyRefs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.connectionConfiguration, this.policyRefs);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        this.connectionConfiguration.encode(buffer);
        buffer.writeInt(this.policyRefs == null ? 0 : this.policyRefs.size());
        for (String policyRef : this.policyRefs) {
            buffer.writeString(policyRef);
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.connectionConfiguration.decode(buffer);
        int policyRefNum = buffer.readInt();
        for (int i = 0; i < policyRefNum; ++i) {
            this.policyRefs.add(buffer.readString());
        }
    }

    public T setStaticConnectors(List<String> connectors) {
        this.connectionConfiguration.setStaticConnectors(connectors);
        return (T)this;
    }
}

