/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public abstract class AbstractFunction
implements FunctionItem {
    @Override
    public OperandRole[] getOperandRoles() {
        Object[] roles = new OperandRole[this.getArity()];
        Arrays.fill(roles, new OperandRole(0, OperandUsage.NAVIGATION));
        return roles;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        throw new XPathException("Function items (other than arrays) cannot be atomized", "FOTY0013");
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        throw new UncheckedXPathException(new XPathException("The string value of a function is not defined", "FOTY0014"));
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("A function has no effective boolean value", "XPTY0004");
    }

    public void simplify() throws XPathException {
    }

    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
    }

    @Override
    public XPathContext makeNewContext(XPathContext callingContext, ContextOriginator originator) {
        return callingContext;
    }

    @Override
    public boolean deepEquals(FunctionItem other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        throw new XPathException("Argument to deep-equal() contains a function item", "FOTY0015");
    }

    @Override
    public boolean deepEqual40(FunctionItem other, XPathContext context, DeepEqual.DeepEqualOptions options) throws XPathException {
        if (options.falseOnError) {
            return false;
        }
        throw new XPathException("Argument to deep-equal() contains a function item", "FOTY0015");
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        throw new UnsupportedOperationException("export() not implemented for " + this.getClass());
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    @Override
    public String toShortString() {
        return this.getDescription();
    }
}

