/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.FNRoundHalfToEven$;
import org.apache.daffodil.runtime1.dpath.RecipeOpWithSubRecipes;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class FNRoundHalfToEven
extends RecipeOpWithSubRecipes
implements Product {
    private final CompiledDPath recipeNum;
    private final CompiledDPath recipePrecision;

    public static FNRoundHalfToEven apply(CompiledDPath compiledDPath, CompiledDPath compiledDPath2) {
        return FNRoundHalfToEven$.MODULE$.apply(compiledDPath, compiledDPath2);
    }

    public static FNRoundHalfToEven fromProduct(Product product) {
        return FNRoundHalfToEven$.MODULE$.fromProduct(product);
    }

    public static FNRoundHalfToEven unapply(FNRoundHalfToEven fNRoundHalfToEven) {
        return FNRoundHalfToEven$.MODULE$.unapply(fNRoundHalfToEven);
    }

    public FNRoundHalfToEven(CompiledDPath recipeNum, CompiledDPath recipePrecision) {
        this.recipeNum = recipeNum;
        this.recipePrecision = recipePrecision;
        super((Seq<CompiledDPath>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompiledDPath[]{recipeNum, recipePrecision}));
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 2020844009, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FNRoundHalfToEven)) return false;
        FNRoundHalfToEven fNRoundHalfToEven = (FNRoundHalfToEven)object;
        CompiledDPath compiledDPath = this.recipeNum();
        CompiledDPath compiledDPath2 = fNRoundHalfToEven.recipeNum();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        CompiledDPath compiledDPath3 = this.recipePrecision();
        CompiledDPath compiledDPath4 = fNRoundHalfToEven.recipePrecision();
        if (compiledDPath3 == null) {
            if (compiledDPath4 != null) {
                return false;
            }
        } else if (!compiledDPath3.equals(compiledDPath4)) return false;
        if (!fNRoundHalfToEven.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FNRoundHalfToEven;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "FNRoundHalfToEven";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipeNum";
        }
        if (1 == n2) {
            return "recipePrecision";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CompiledDPath recipeNum() {
        return this.recipeNum;
    }

    public CompiledDPath recipePrecision() {
        return this.recipePrecision;
    }

    @Override
    public void run(DState dstate) {
        BigDecimal rounded;
        BigDecimal bigDecimal;
        DINode savedNode = dstate.currentNode();
        this.recipeNum().run(dstate);
        Object unrounded = dstate.currentValue();
        dstate.setCurrentNode(savedNode);
        this.recipePrecision().run(dstate);
        int precision = dstate.intValue();
        Object object = DataValue$.MODULE$.getAnyRef$extension(unrounded);
        if (object instanceof String) {
            String s = (String)object;
            bigDecimal = new BigDecimal(s);
        } else if (object instanceof Long) {
            Long l = (Long)object;
            bigDecimal = BigDecimal.ONE;
        } else if (object instanceof Float) {
            Float f = (Float)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Float2float(f));
        } else if (object instanceof Double) {
            Double d = (Double)object;
            bigDecimal = BigDecimal.valueOf(Predef$.MODULE$.Double2double(d));
        } else if (object instanceof BigDecimal) {
            BigDecimal bd;
            bigDecimal = bd = (BigDecimal)object;
        } else {
            throw Assert$.MODULE$.invariantFailed("not a number");
        }
        BigDecimal bd = bigDecimal;
        BigDecimal value = rounded = bd.setScale(precision, RoundingMode.HALF_EVEN);
        dstate.setCurrentValue(DataValue$.MODULE$.toDataValue(value));
    }

    public FNRoundHalfToEven copy(CompiledDPath recipeNum, CompiledDPath recipePrecision) {
        return new FNRoundHalfToEven(recipeNum, recipePrecision);
    }

    public CompiledDPath copy$default$1() {
        return this.recipeNum();
    }

    public CompiledDPath copy$default$2() {
        return this.recipePrecision();
    }

    public CompiledDPath _1() {
        return this.recipeNum();
    }

    public CompiledDPath _2() {
        return this.recipePrecision();
    }
}

