/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public final class Round
extends SystemFunction {
    @Override
    public int getCardinality(Expression[] arguments) {
        return arguments[0].getCardinality();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue val0 = (NumericValue)arguments[0].head();
        if (val0 == null) {
            return EmptySequence.getInstance();
        }
        int scaleRnd = 0;
        RoundingRule roundingRule = RoundingRule.HALF_TO_CEILING;
        if (arguments.length >= 2) {
            NumericValue scaleVal = (NumericValue)arguments[1].head();
            int n = scaleRnd = scaleVal == null ? 0 : (int)scaleVal.longValue();
        }
        if (arguments.length >= 3) {
            StringValue rounding = (StringValue)arguments[2].head();
            RoundingRule roundingRule2 = roundingRule = rounding == null ? RoundingRule.HALF_TO_CEILING : Round.getRoundingRule(rounding.getStringValue());
        }
        if (roundingRule == RoundingRule.HALF_TO_CEILING) {
            return val0.round(scaleRnd);
        }
        return val0.round(scaleRnd, roundingRule);
    }

    @Override
    public Elaborator getElaborator() {
        return new RoundElaborator();
    }

    public static RoundingRule getRoundingRule(String s) throws XPathException {
        switch (s) {
            case "toward-zero": {
                return RoundingRule.TOWARD_ZERO;
            }
            case "away-from-zero": {
                return RoundingRule.AWAY_FROM_ZERO;
            }
            case "ceiling": {
                return RoundingRule.CEILING;
            }
            case "floor": {
                return RoundingRule.FLOOR;
            }
            case "half-toward-zero": {
                return RoundingRule.HALF_TOWARD_ZERO;
            }
            case "half-away-from-zero": {
                return RoundingRule.HALF_AWAY_FROM_ZERO;
            }
            case "half-to-ceiling": {
                return RoundingRule.HALF_TO_CEILING;
            }
            case "half-to-floor": {
                return RoundingRule.HALF_TO_FLOOR;
            }
            case "half-to-even": {
                return RoundingRule.HALF_TO_EVEN;
            }
        }
        throw new XPathException("Invalid rounding mode " + s, "XPTY0004");
    }

    public static enum RoundingRule {
        FLOOR,
        CEILING,
        TOWARD_ZERO,
        AWAY_FROM_ZERO,
        HALF_TO_FLOOR,
        HALF_TO_CEILING,
        HALF_TOWARD_ZERO,
        HALF_AWAY_FROM_ZERO,
        HALF_TO_EVEN;

    }

    public static class RoundElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator argEval = fnc.getArg(0).makeElaborator().elaborateForItem();
            boolean nullable = Cardinality.allowsZero(fnc.getArg(0).getCardinality());
            if (fnc.getArity() == 1) {
                if (nullable) {
                    return context -> {
                        NumericValue result = (NumericValue)argEval.eval(context);
                        if (result == null) {
                            return null;
                        }
                        return result.round(0);
                    };
                }
                return context -> ((NumericValue)argEval.eval(context)).round(0);
            }
            if (fnc.getArity() == 2) {
                ItemEvaluator scaleArg = fnc.getArg(1).makeElaborator().elaborateForItem();
                return context -> {
                    NumericValue result = (NumericValue)argEval.eval(context);
                    if (result == null) {
                        return null;
                    }
                    IntegerValue scaleArgVal = (IntegerValue)scaleArg.eval(context);
                    if (scaleArgVal == null) {
                        return result.round(0);
                    }
                    int scale = (int)scaleArgVal.longValue();
                    return result.round(scale);
                };
            }
            ItemEvaluator scaleArg = fnc.getArg(1).makeElaborator().elaborateForItem();
            ItemEvaluator modeArg = fnc.getArg(2).makeElaborator().elaborateForItem();
            return context -> {
                RoundingRule mode;
                NumericValue result = (NumericValue)argEval.eval(context);
                if (result == null) {
                    return null;
                }
                IntegerValue scaleArgVal = (IntegerValue)scaleArg.eval(context);
                int scale = scaleArgVal == null ? 0 : (int)scaleArgVal.longValue();
                StringValue midpointModeVal = (StringValue)modeArg.eval(context);
                RoundingRule roundingRule = mode = midpointModeVal == null ? RoundingRule.HALF_TO_CEILING : Round.getRoundingRule(midpointModeVal.getStringValue());
                if (mode == RoundingRule.HALF_TO_CEILING) {
                    return result.round(scale);
                }
                return result.round(scale, mode);
            };
        }
    }
}

