/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TCLog
implements Interceptor {
    private boolean debug;
    private Log logger = null;

    public TCLog(String name) {
        this(name, false);
    }

    public TCLog(String name, boolean isDebug) {
        this.logger = LogFactory.getLog((String)name);
        this.debug = isDebug;
    }

    public void info(String str) {
        if (this.debug) {
            this.logger.info((Object)str);
        }
    }

    public void info(String str, Throwable t) {
        if (this.debug) {
            this.logger.info((Object)str, t);
        }
    }

    public void debug(String str) {
        if (this.debug) {
            this.logger.debug((Object)str);
        }
    }

    public void debug(String str, Throwable t) {
        if (this.debug) {
            this.logger.debug((Object)str, t);
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String req = "send request, request url: " + request.urlString() + ". request headers information: " + request.headers().toString();
        req = req.replaceAll("\n", ";");
        this.info(req);
        Response response = chain.proceed(request);
        String resp = "recieve response, response url: " + response.request().urlString() + ", response headers: " + response.headers().toString() + ",response body information: " + response.body().toString();
        resp = resp.replaceAll("\n", ";");
        this.info(resp);
        return response;
    }
}

