/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AutoMLCandidate;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AutoMLCandidateMarshaller {
    private static final MarshallingInfo<String> CANDIDATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CandidateName").build();
    private static final MarshallingInfo<StructuredPojo> FINALAUTOMLJOBOBJECTIVEMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinalAutoMLJobObjectiveMetric").build();
    private static final MarshallingInfo<String> OBJECTIVESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectiveStatus").build();
    private static final MarshallingInfo<List> CANDIDATESTEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CandidateSteps").build();
    private static final MarshallingInfo<String> CANDIDATESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CandidateStatus").build();
    private static final MarshallingInfo<List> INFERENCECONTAINERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InferenceContainers").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<StructuredPojo> CANDIDATEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CandidateProperties").build();
    private static final AutoMLCandidateMarshaller instance = new AutoMLCandidateMarshaller();

    public static AutoMLCandidateMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutoMLCandidate autoMLCandidate, ProtocolMarshaller protocolMarshaller) {
        if (autoMLCandidate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)autoMLCandidate.getCandidateName(), CANDIDATENAME_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getFinalAutoMLJobObjectiveMetric(), FINALAUTOMLJOBOBJECTIVEMETRIC_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getObjectiveStatus(), OBJECTIVESTATUS_BINDING);
            protocolMarshaller.marshall(autoMLCandidate.getCandidateSteps(), CANDIDATESTEPS_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getCandidateStatus(), CANDIDATESTATUS_BINDING);
            protocolMarshaller.marshall(autoMLCandidate.getInferenceContainers(), INFERENCECONTAINERS_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)autoMLCandidate.getCandidateProperties(), CANDIDATEPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

