/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WorkerLoadBalancerConfigurationProperties;
import org.apache.dolphinscheduler.server.master.config.CommandFetchStrategy;
import org.apache.dolphinscheduler.server.master.config.LogicTaskConfig;
import org.apache.dolphinscheduler.server.master.config.MasterServerLoadProtectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="master")
public class MasterConfig
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterConfig.class);
    private int listenPort = 5678;
    private int workflowEventBusFireThreadCount = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private LogicTaskConfig logicTaskConfig = new LogicTaskConfig();
    private Duration maxHeartbeatInterval = Duration.ofSeconds(10L);
    private MasterServerLoadProtectionConfig serverLoadProtection = new MasterServerLoadProtectionConfig();
    private Duration workerGroupRefreshInterval = Duration.ofMinutes(5L);
    private CommandFetchStrategy commandFetchStrategy = new CommandFetchStrategy();
    private WorkerLoadBalancerConfigurationProperties workerLoadBalancerConfigurationProperties = new WorkerLoadBalancerConfigurationProperties();
    private String masterAddress;
    private String masterRegistryPath;

    public boolean supports(Class<?> clazz) {
        return MasterConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        MasterConfig masterConfig = (MasterConfig)target;
        if (masterConfig.getListenPort() <= 0) {
            errors.rejectValue("listen-port", null, "is invalidated");
        }
        if (masterConfig.getWorkflowEventBusFireThreadCount() <= 0) {
            errors.rejectValue("workflow-event-bus-fire-thread-count", null, "should be a positive value");
        }
        if (masterConfig.getMaxHeartbeatInterval().toMillis() < 0L) {
            errors.rejectValue("max-heartbeat-interval", null, "should be a valid duration");
        }
        if (masterConfig.getWorkerGroupRefreshInterval().getSeconds() < 10L) {
            errors.rejectValue("worker-group-refresh-interval", null, "should >= 10s");
        }
        if (StringUtils.isEmpty((CharSequence)masterConfig.getMasterAddress())) {
            masterConfig.setMasterAddress(NetUtils.getAddr((int)masterConfig.getListenPort()));
        }
        this.commandFetchStrategy.validate(errors);
        this.workerLoadBalancerConfigurationProperties.validate(errors);
        masterConfig.setMasterRegistryPath(RegistryNodeType.MASTER.getRegistryPath() + "/" + masterConfig.getMasterAddress());
        this.printConfig();
    }

    private void printConfig() {
        String config = "\n****************************Master Configuration**************************************\n  listen-port -> " + this.listenPort + "\n  workflow-event-bus-fire-thread-count -> " + this.workflowEventBusFireThreadCount + "\n  logic-task-config -> " + this.logicTaskConfig + "\n  max-heartbeat-interval -> " + this.maxHeartbeatInterval + "\n  server-load-protection -> " + (Object)((Object)this.serverLoadProtection) + "\n  master-address -> " + this.masterAddress + "\n  master-registry-path: " + this.masterRegistryPath + "\n  worker-group-refresh-interval: " + this.workerGroupRefreshInterval + "\n  command-fetch-strategy: " + this.commandFetchStrategy + "\n  worker-load-balancer-configuration-properties: " + this.workerLoadBalancerConfigurationProperties + "\n****************************Master Configuration**************************************";
        log.info(config);
    }

    @Generated
    public MasterConfig() {
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public int getWorkflowEventBusFireThreadCount() {
        return this.workflowEventBusFireThreadCount;
    }

    @Generated
    public LogicTaskConfig getLogicTaskConfig() {
        return this.logicTaskConfig;
    }

    @Generated
    public Duration getMaxHeartbeatInterval() {
        return this.maxHeartbeatInterval;
    }

    @Generated
    public MasterServerLoadProtectionConfig getServerLoadProtection() {
        return this.serverLoadProtection;
    }

    @Generated
    public Duration getWorkerGroupRefreshInterval() {
        return this.workerGroupRefreshInterval;
    }

    @Generated
    public CommandFetchStrategy getCommandFetchStrategy() {
        return this.commandFetchStrategy;
    }

    @Generated
    public WorkerLoadBalancerConfigurationProperties getWorkerLoadBalancerConfigurationProperties() {
        return this.workerLoadBalancerConfigurationProperties;
    }

    @Generated
    public String getMasterAddress() {
        return this.masterAddress;
    }

    @Generated
    public String getMasterRegistryPath() {
        return this.masterRegistryPath;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setWorkflowEventBusFireThreadCount(int workflowEventBusFireThreadCount) {
        this.workflowEventBusFireThreadCount = workflowEventBusFireThreadCount;
    }

    @Generated
    public void setLogicTaskConfig(LogicTaskConfig logicTaskConfig) {
        this.logicTaskConfig = logicTaskConfig;
    }

    @Generated
    public void setMaxHeartbeatInterval(Duration maxHeartbeatInterval) {
        this.maxHeartbeatInterval = maxHeartbeatInterval;
    }

    @Generated
    public void setServerLoadProtection(MasterServerLoadProtectionConfig serverLoadProtection) {
        this.serverLoadProtection = serverLoadProtection;
    }

    @Generated
    public void setWorkerGroupRefreshInterval(Duration workerGroupRefreshInterval) {
        this.workerGroupRefreshInterval = workerGroupRefreshInterval;
    }

    @Generated
    public void setCommandFetchStrategy(CommandFetchStrategy commandFetchStrategy) {
        this.commandFetchStrategy = commandFetchStrategy;
    }

    @Generated
    public void setWorkerLoadBalancerConfigurationProperties(WorkerLoadBalancerConfigurationProperties workerLoadBalancerConfigurationProperties) {
        this.workerLoadBalancerConfigurationProperties = workerLoadBalancerConfigurationProperties;
    }

    @Generated
    public void setMasterAddress(String masterAddress) {
        this.masterAddress = masterAddress;
    }

    @Generated
    public void setMasterRegistryPath(String masterRegistryPath) {
        this.masterRegistryPath = masterRegistryPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterConfig)) {
            return false;
        }
        MasterConfig other = (MasterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getWorkflowEventBusFireThreadCount() != other.getWorkflowEventBusFireThreadCount()) {
            return false;
        }
        LogicTaskConfig this$logicTaskConfig = this.getLogicTaskConfig();
        LogicTaskConfig other$logicTaskConfig = other.getLogicTaskConfig();
        if (this$logicTaskConfig == null ? other$logicTaskConfig != null : !((Object)this$logicTaskConfig).equals(other$logicTaskConfig)) {
            return false;
        }
        Duration this$maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        Duration other$maxHeartbeatInterval = other.getMaxHeartbeatInterval();
        if (this$maxHeartbeatInterval == null ? other$maxHeartbeatInterval != null : !((Object)this$maxHeartbeatInterval).equals(other$maxHeartbeatInterval)) {
            return false;
        }
        MasterServerLoadProtectionConfig this$serverLoadProtection = this.getServerLoadProtection();
        MasterServerLoadProtectionConfig other$serverLoadProtection = other.getServerLoadProtection();
        if (this$serverLoadProtection == null ? other$serverLoadProtection != null : !((Object)((Object)this$serverLoadProtection)).equals((Object)other$serverLoadProtection)) {
            return false;
        }
        Duration this$workerGroupRefreshInterval = this.getWorkerGroupRefreshInterval();
        Duration other$workerGroupRefreshInterval = other.getWorkerGroupRefreshInterval();
        if (this$workerGroupRefreshInterval == null ? other$workerGroupRefreshInterval != null : !((Object)this$workerGroupRefreshInterval).equals(other$workerGroupRefreshInterval)) {
            return false;
        }
        CommandFetchStrategy this$commandFetchStrategy = this.getCommandFetchStrategy();
        CommandFetchStrategy other$commandFetchStrategy = other.getCommandFetchStrategy();
        if (this$commandFetchStrategy == null ? other$commandFetchStrategy != null : !((Object)this$commandFetchStrategy).equals(other$commandFetchStrategy)) {
            return false;
        }
        WorkerLoadBalancerConfigurationProperties this$workerLoadBalancerConfigurationProperties = this.getWorkerLoadBalancerConfigurationProperties();
        WorkerLoadBalancerConfigurationProperties other$workerLoadBalancerConfigurationProperties = other.getWorkerLoadBalancerConfigurationProperties();
        if (this$workerLoadBalancerConfigurationProperties == null ? other$workerLoadBalancerConfigurationProperties != null : !((Object)this$workerLoadBalancerConfigurationProperties).equals(other$workerLoadBalancerConfigurationProperties)) {
            return false;
        }
        String this$masterAddress = this.getMasterAddress();
        String other$masterAddress = other.getMasterAddress();
        if (this$masterAddress == null ? other$masterAddress != null : !this$masterAddress.equals(other$masterAddress)) {
            return false;
        }
        String this$masterRegistryPath = this.getMasterRegistryPath();
        String other$masterRegistryPath = other.getMasterRegistryPath();
        return !(this$masterRegistryPath == null ? other$masterRegistryPath != null : !this$masterRegistryPath.equals(other$masterRegistryPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MasterConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getWorkflowEventBusFireThreadCount();
        LogicTaskConfig $logicTaskConfig = this.getLogicTaskConfig();
        result = result * 59 + ($logicTaskConfig == null ? 43 : ((Object)$logicTaskConfig).hashCode());
        Duration $maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        result = result * 59 + ($maxHeartbeatInterval == null ? 43 : ((Object)$maxHeartbeatInterval).hashCode());
        MasterServerLoadProtectionConfig $serverLoadProtection = this.getServerLoadProtection();
        result = result * 59 + ($serverLoadProtection == null ? 43 : ((Object)((Object)$serverLoadProtection)).hashCode());
        Duration $workerGroupRefreshInterval = this.getWorkerGroupRefreshInterval();
        result = result * 59 + ($workerGroupRefreshInterval == null ? 43 : ((Object)$workerGroupRefreshInterval).hashCode());
        CommandFetchStrategy $commandFetchStrategy = this.getCommandFetchStrategy();
        result = result * 59 + ($commandFetchStrategy == null ? 43 : ((Object)$commandFetchStrategy).hashCode());
        WorkerLoadBalancerConfigurationProperties $workerLoadBalancerConfigurationProperties = this.getWorkerLoadBalancerConfigurationProperties();
        result = result * 59 + ($workerLoadBalancerConfigurationProperties == null ? 43 : ((Object)$workerLoadBalancerConfigurationProperties).hashCode());
        String $masterAddress = this.getMasterAddress();
        result = result * 59 + ($masterAddress == null ? 43 : $masterAddress.hashCode());
        String $masterRegistryPath = this.getMasterRegistryPath();
        result = result * 59 + ($masterRegistryPath == null ? 43 : $masterRegistryPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MasterConfig(listenPort=" + this.getListenPort() + ", workflowEventBusFireThreadCount=" + this.getWorkflowEventBusFireThreadCount() + ", logicTaskConfig=" + this.getLogicTaskConfig() + ", maxHeartbeatInterval=" + this.getMaxHeartbeatInterval() + ", serverLoadProtection=" + (Object)((Object)this.getServerLoadProtection()) + ", workerGroupRefreshInterval=" + this.getWorkerGroupRefreshInterval() + ", commandFetchStrategy=" + this.getCommandFetchStrategy() + ", workerLoadBalancerConfigurationProperties=" + this.getWorkerLoadBalancerConfigurationProperties() + ", masterAddress=" + this.getMasterAddress() + ", masterRegistryPath=" + this.getMasterRegistryPath() + ")";
    }
}

