/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.engine.executor.LogicTaskEngineFactory;
import org.apache.dolphinscheduler.server.master.engine.executor.LogicTaskExecutorFactory;
import org.apache.dolphinscheduler.server.master.engine.executor.LogicTaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.TaskEngine;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicTaskEngineDelegator
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskEngineDelegator.class);
    private final TaskEngine taskEngine;
    private final LogicTaskExecutorFactory logicTaskExecutorFactory;
    private final LogicTaskExecutorLifecycleEventReporter logicTaskExecutorEventReporter;

    public LogicTaskEngineDelegator(LogicTaskEngineFactory logicTaskEngineFactory, LogicTaskExecutorFactory logicTaskExecutorFactory, LogicTaskExecutorLifecycleEventReporter logicTaskExecutorEventReporter) {
        this.logicTaskExecutorFactory = logicTaskExecutorFactory;
        this.taskEngine = logicTaskEngineFactory.createTaskEngine();
        this.logicTaskExecutorEventReporter = logicTaskExecutorEventReporter;
    }

    public void start() {
        this.taskEngine.start();
        this.logicTaskExecutorEventReporter.start();
        log.info("LogicTaskEngineDelegator started");
    }

    public void dispatchLogicTask(TaskExecutionContext taskExecutionContext) {
        ITaskExecutor taskExecutor = this.logicTaskExecutorFactory.createTaskExecutor(taskExecutionContext);
        this.taskEngine.submitTask(taskExecutor);
    }

    public void killLogicTask(int taskInstanceId) {
        this.taskEngine.killTask(taskInstanceId);
    }

    public void pauseLogicTask(int taskInstanceId) {
        this.taskEngine.pauseTask(taskInstanceId);
    }

    public void ackLogicTaskExecutionEvent(ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        this.logicTaskExecutorEventReporter.receiveTaskExecutorLifecycleEventACK(taskExecutorLifecycleEventAck);
    }

    @Override
    public void close() {
        try (TaskEngine ignore1 = this.taskEngine;
             LogicTaskExecutorLifecycleEventReporter ignore2 = this.logicTaskExecutorEventReporter;){
            log.info("LogicTaskEngineDelegator closed");
        }
    }
}

