/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.AbstractTaskLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;

public class TaskRetryLifecycleEvent
extends AbstractTaskLifecycleEvent {
    private final ITaskExecutionRunnable taskExecutionRunnable;

    protected TaskRetryLifecycleEvent(ITaskExecutionRunnable taskExecutionRunnable, long delayTime) {
        super(delayTime);
        this.taskExecutionRunnable = taskExecutionRunnable;
    }

    public static TaskRetryLifecycleEvent of(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        Preconditions.checkState((taskInstance != null ? 1 : 0) != 0, (Object)"The task instance must be initialized before retrying.");
        int delayTime = taskInstance.getRetryInterval();
        int retryTimes = taskInstance.getRetryTimes();
        int maxRetryTimes = taskInstance.getMaxRetryTimes();
        Preconditions.checkState((retryTimes < maxRetryTimes ? 1 : 0) != 0, (String)"The task retry times: %s must smaller then maxRetryTimes: %s.", (int)retryTimes, (int)maxRetryTimes);
        long remainingTime = TimeUnit.MINUTES.toMillis(delayTime) + System.currentTimeMillis() - taskInstance.getEndTime().getTime();
        return new TaskRetryLifecycleEvent(taskExecutionRunnable, remainingTime);
    }

    @Override
    public ILifecycleEventType getEventType() {
        return TaskLifecycleEventType.RETRY;
    }

    public String toString() {
        return "TaskRetryLifecycleEvent{task=" + this.taskExecutionRunnable.getName() + ", delayTime=" + this.delayTime + "/ms" + '}';
    }

    @Override
    @Generated
    public ITaskExecutionRunnable getTaskExecutionRunnable() {
        return this.taskExecutionRunnable;
    }
}

