/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CertificateSigningRequestSpec contains the certificate request.")
public class V1CertificateSigningRequestSpec {
    public static final String SERIALIZED_NAME_EXTRA = "extra";
    @SerializedName(value="extra")
    private Map<String, List<String>> extra = null;
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private List<String> groups = null;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private byte[] request;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private String uid;
    public static final String SERIALIZED_NAME_USAGES = "usages";
    @SerializedName(value="usages")
    private List<String> usages = null;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;

    public V1CertificateSigningRequestSpec extra(Map<String, List<String>> extra) {
        this.extra = extra;
        return this;
    }

    public V1CertificateSigningRequestSpec putExtraItem(String key, List<String> extraItem) {
        if (this.extra == null) {
            this.extra = new HashMap<String, List<String>>();
        }
        this.extra.put(key, extraItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="extra contains extra attributes of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, List<String>> extra) {
        this.extra = extra;
    }

    public V1CertificateSigningRequestSpec groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public V1CertificateSigningRequestSpec addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="groups contains group membership of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public V1CertificateSigningRequestSpec request(byte[] request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(required=true, value="request contains an x509 certificate signing request encoded in a \"CERTIFICATE REQUEST\" PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.")
    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public V1CertificateSigningRequestSpec signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @ApiModelProperty(required=true, value="signerName indicates the requested signer, and is a qualified name.  List/watch requests for CertificateSigningRequests can filter on this field using a \"spec.signerName=NAME\" fieldSelector.  Well-known Kubernetes signers are:  1. \"kubernetes.io/kube-apiserver-client\": issues client certificates that can be used to authenticate to kube-apiserver.   Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the \"csrsigning\" controller in kube-controller-manager.  2. \"kubernetes.io/kube-apiserver-client-kubelet\": issues client certificates that kubelets use to authenticate to kube-apiserver.   Requests for this signer can be auto-approved by the \"csrapproving\" controller in kube-controller-manager, and can be issued by the \"csrsigning\" controller in kube-controller-manager.  3. \"kubernetes.io/kubelet-serving\" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.   Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the \"csrsigning\" controller in kube-controller-manager.  More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers  Custom signerNames can also be specified. The signer defines:  1. Trust distribution: how trust (CA bundles) are distributed.  2. Permitted subjects: and behavior when a disallowed subject is requested.  3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.  4. Required, permitted, or forbidden key usages / extended key usages.  5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.  6. Whether or not requests for CA certificates are allowed.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public V1CertificateSigningRequestSpec uid(String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="uid contains the uid of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public V1CertificateSigningRequestSpec usages(List<String> usages) {
        this.usages = usages;
        return this;
    }

    public V1CertificateSigningRequestSpec addUsagesItem(String usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="usages specifies a set of key usages requested in the issued certificate.  Requests for TLS client certificates typically request: \"digital signature\", \"key encipherment\", \"client auth\".  Requests for TLS serving certificates typically request: \"key encipherment\", \"digital signature\", \"server auth\".  Valid values are:  \"signing\", \"digital signature\", \"content commitment\",  \"key encipherment\", \"key agreement\", \"data encipherment\",  \"cert sign\", \"crl sign\", \"encipher only\", \"decipher only\", \"any\",  \"server auth\", \"client auth\",  \"code signing\", \"email protection\", \"s/mime\",  \"ipsec end system\", \"ipsec tunnel\", \"ipsec user\",  \"timestamping\", \"ocsp signing\", \"microsoft sgc\", \"netscape sgc\"")
    public List<String> getUsages() {
        return this.usages;
    }

    public void setUsages(List<String> usages) {
        this.usages = usages;
    }

    public V1CertificateSigningRequestSpec username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="username contains the name of the user that created the CertificateSigningRequest. Populated by the API server on creation and immutable.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CertificateSigningRequestSpec v1CertificateSigningRequestSpec = (V1CertificateSigningRequestSpec)o;
        return Objects.equals(this.extra, v1CertificateSigningRequestSpec.extra) && Objects.equals(this.groups, v1CertificateSigningRequestSpec.groups) && Arrays.equals(this.request, v1CertificateSigningRequestSpec.request) && Objects.equals(this.signerName, v1CertificateSigningRequestSpec.signerName) && Objects.equals(this.uid, v1CertificateSigningRequestSpec.uid) && Objects.equals(this.usages, v1CertificateSigningRequestSpec.usages) && Objects.equals(this.username, v1CertificateSigningRequestSpec.username);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.groups, Arrays.hashCode(this.request), this.signerName, this.uid, this.usages, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CertificateSigningRequestSpec {\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

