/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class FactoryProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="createTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createTime;
    @JsonProperty(value="version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="purviewConfiguration")
    private PurviewConfiguration purviewConfiguration;
    @JsonProperty(value="repoConfiguration")
    private FactoryRepoConfiguration repoConfiguration;
    @JsonProperty(value="globalParameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, GlobalParameterSpecification> globalParameters;
    @JsonProperty(value="encryption")
    private EncryptionConfiguration encryption;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public String version() {
        return this.version;
    }

    public PurviewConfiguration purviewConfiguration() {
        return this.purviewConfiguration;
    }

    public FactoryProperties withPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        this.purviewConfiguration = purviewConfiguration;
        return this;
    }

    public FactoryRepoConfiguration repoConfiguration() {
        return this.repoConfiguration;
    }

    public FactoryProperties withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        this.repoConfiguration = repoConfiguration;
        return this;
    }

    public Map<String, GlobalParameterSpecification> globalParameters() {
        return this.globalParameters;
    }

    public FactoryProperties withGlobalParameters(Map<String, GlobalParameterSpecification> globalParameters) {
        this.globalParameters = globalParameters;
        return this;
    }

    public EncryptionConfiguration encryption() {
        return this.encryption;
    }

    public FactoryProperties withEncryption(EncryptionConfiguration encryption) {
        this.encryption = encryption;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public FactoryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.purviewConfiguration() != null) {
            this.purviewConfiguration().validate();
        }
        if (this.repoConfiguration() != null) {
            this.repoConfiguration().validate();
        }
        if (this.globalParameters() != null) {
            this.globalParameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }
}

