/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.CredentialOperationsClient;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIdentityCredentialResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ManagedIdentityCredentialResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.CredentialOperations;
import com.azure.resourcemanager.datafactory.models.ManagedIdentityCredentialResource;

public final class CredentialOperationsImpl
implements CredentialOperations {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialOperationsImpl.class);
    private final CredentialOperationsClient innerClient;
    private final DataFactoryManager serviceManager;

    public CredentialOperationsImpl(CredentialOperationsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ManagedIdentityCredentialResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<ManagedIdentityCredentialResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return Utils.mapPage(inner, inner1 -> new ManagedIdentityCredentialResourceImpl((ManagedIdentityCredentialResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedIdentityCredentialResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<ManagedIdentityCredentialResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return Utils.mapPage(inner, inner1 -> new ManagedIdentityCredentialResourceImpl((ManagedIdentityCredentialResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ManagedIdentityCredentialResource> getWithResponse(String resourceGroupName, String factoryName, String credentialName, String ifNoneMatch, Context context) {
        Response<ManagedIdentityCredentialResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, credentialName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedIdentityCredentialResourceImpl((ManagedIdentityCredentialResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedIdentityCredentialResource get(String resourceGroupName, String factoryName, String credentialName) {
        ManagedIdentityCredentialResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, credentialName);
        if (inner != null) {
            return new ManagedIdentityCredentialResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String credentialName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, credentialName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String credentialName) {
        this.serviceClient().delete(resourceGroupName, factoryName, credentialName);
    }

    @Override
    public ManagedIdentityCredentialResource getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = Utils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        String localIfNoneMatch = null;
        return (ManagedIdentityCredentialResource)this.getWithResponse(resourceGroupName, factoryName, credentialName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedIdentityCredentialResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = Utils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, credentialName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = Utils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, credentialName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String credentialName = Utils.getValueFromIdByName(id, "credentials");
        if (credentialName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'credentials'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, credentialName, context);
    }

    private CredentialOperationsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedIdentityCredentialResourceImpl define(String name) {
        return new ManagedIdentityCredentialResourceImpl(name, this.manager());
    }
}

