/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.Office365LinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Office365")
public final class Office365LinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private Office365LinkedServiceTypeProperties innerTypeProperties = new Office365LinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(Office365LinkedService.class);

    private Office365LinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public Office365LinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public Office365LinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public Office365LinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public Office365LinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object office365TenantId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().office365TenantId();
    }

    public Office365LinkedService withOffice365TenantId(Object office365TenantId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withOffice365TenantId(office365TenantId);
        return this;
    }

    public Object servicePrincipalTenantId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalTenantId();
    }

    public Office365LinkedService withServicePrincipalTenantId(Object servicePrincipalTenantId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalTenantId(servicePrincipalTenantId);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public Office365LinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public Office365LinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public Office365LinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365LinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model Office365LinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

