/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SwitchActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.azure.resourcemanager.datafactory.models.SwitchCase;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Switch")
public final class SwitchActivity
extends ControlActivity {
    @JsonProperty(value="typeProperties", required=true)
    private SwitchActivityTypeProperties innerTypeProperties = new SwitchActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SwitchActivity.class);

    private SwitchActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SwitchActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SwitchActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SwitchActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SwitchActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Expression on() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().on();
    }

    public SwitchActivity withOn(Expression on) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SwitchActivityTypeProperties();
        }
        this.innerTypeProperties().withOn(on);
        return this;
    }

    public List<SwitchCase> cases() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().cases();
    }

    public SwitchActivity withCases(List<SwitchCase> cases) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SwitchActivityTypeProperties();
        }
        this.innerTypeProperties().withCases(cases);
        return this;
    }

    public List<Activity> defaultActivities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().defaultActivities();
    }

    public SwitchActivity withDefaultActivities(List<Activity> defaultActivities) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SwitchActivityTypeProperties();
        }
        this.innerTypeProperties().withDefaultActivities(defaultActivities);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SwitchActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

