/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.WebActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebActivityMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="WebActivity")
public final class WebActivity
extends ExecutionActivity {
    @JsonProperty(value="typeProperties", required=true)
    private WebActivityTypeProperties innerTypeProperties = new WebActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(WebActivity.class);

    private WebActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public WebActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public WebActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public WebActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public WebActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public WebActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public WebActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public WebActivityMethod method() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().method();
    }

    public WebActivity withMethod(WebActivityMethod method) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withMethod(method);
        return this;
    }

    public Object url() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().url();
    }

    public WebActivity withUrl(Object url) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withUrl(url);
        return this;
    }

    public Object headers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().headers();
    }

    public WebActivity withHeaders(Object headers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withHeaders(headers);
        return this;
    }

    public Object body() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().body();
    }

    public WebActivity withBody(Object body) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withBody(body);
        return this;
    }

    public WebActivityAuthentication authentication() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authentication();
    }

    public WebActivity withAuthentication(WebActivityAuthentication authentication) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withAuthentication(authentication);
        return this;
    }

    public Boolean disableCertValidation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().disableCertValidation();
    }

    public WebActivity withDisableCertValidation(Boolean disableCertValidation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withDisableCertValidation(disableCertValidation);
        return this;
    }

    public List<DatasetReference> datasets() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().datasets();
    }

    public WebActivity withDatasets(List<DatasetReference> datasets) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withDatasets(datasets);
        return this;
    }

    public List<LinkedServiceReference> linkedServices() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedServices();
    }

    public WebActivity withLinkedServices(List<LinkedServiceReference> linkedServices) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withLinkedServices(linkedServices);
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectVia();
    }

    public WebActivity withConnectVia(IntegrationRuntimeReference connectVia) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new WebActivityTypeProperties();
        }
        this.innerTypeProperties().withConnectVia(connectVia);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model WebActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

