/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.metrics.WorkflowInstanceMetrics;
import org.springframework.stereotype.Component;

@Component
public class WorkflowCacheRepository
implements IWorkflowRepository {
    private final Map<Integer, IWorkflowExecutionRunnable> workflowExecutionRunnableMap = new ConcurrentHashMap<Integer, IWorkflowExecutionRunnable>();

    @PostConstruct
    public void registerMetrics() {
        WorkflowInstanceMetrics.registerWorkflowInstanceRunningGauge(this.workflowExecutionRunnableMap::size);
    }

    @Override
    public IWorkflowExecutionRunnable get(int workflowInstanceId) {
        return this.workflowExecutionRunnableMap.get(workflowInstanceId);
    }

    @Override
    public boolean contains(int workflowInstanceId) {
        return this.workflowExecutionRunnableMap.containsKey(workflowInstanceId);
    }

    @Override
    public void remove(int workflowInstanceId) {
        this.workflowExecutionRunnableMap.remove(workflowInstanceId);
    }

    @Override
    public void put(@NonNull IWorkflowExecutionRunnable workflowExecutionRunnable) {
        if (workflowExecutionRunnable == null) {
            throw new NullPointerException("workflowExecutionRunnable is marked non-null but is null");
        }
        Integer workflowInstanceId = workflowExecutionRunnable.getId();
        this.workflowExecutionRunnableMap.put(workflowInstanceId, workflowExecutionRunnable);
    }

    @Override
    public Collection<IWorkflowExecutionRunnable> getAll() {
        return ImmutableList.copyOf(this.workflowExecutionRunnableMap.values());
    }
}

