/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.io.Serializable;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.dao.repository.UserDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.IWorkflowTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractWorkflowInstanceTrigger<TriggerRequest, TriggerResponse>
implements IWorkflowTrigger<TriggerRequest, TriggerResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowInstanceTrigger.class);
    @Autowired
    private WorkflowDefinitionLogDao workflowDefinitionDao;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private CommandDao commandDao;

    @Override
    @Transactional
    public TriggerResponse triggerWorkflow(TriggerRequest triggerRequest) {
        WorkflowInstance workflowInstance = this.constructWorkflowInstance(triggerRequest);
        this.workflowInstanceDao.updateById((Object)workflowInstance);
        Command command = this.constructTriggerCommand(triggerRequest, workflowInstance);
        this.commandDao.insert((Object)command);
        return this.onTriggerSuccess(workflowInstance);
    }

    protected abstract WorkflowInstance constructWorkflowInstance(TriggerRequest var1);

    protected abstract Command constructTriggerCommand(TriggerRequest var1, WorkflowInstance var2);

    protected abstract TriggerResponse onTriggerSuccess(WorkflowInstance var1);

    protected WorkflowInstance getWorkflowInstance(Integer workflowInstanceId) {
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)workflowInstanceId);
        if (workflowInstance == null) {
            throw new IllegalStateException("Workflow instance not found: " + workflowInstanceId);
        }
        return workflowInstance;
    }
}

