/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ApplicationInfo;

public abstract class AbstractRemoteTask
extends AbstractTask {
    protected AbstractRemoteTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
    }

    @Override
    public void cancel() throws TaskException {
        this.cancelApplication();
    }

    public abstract List<String> getApplicationIds() throws TaskException;

    public abstract void cancelApplication() throws TaskException;

    @Override
    public void handle(TaskCallBack taskCallBack) throws TaskException {
        if (StringUtils.isNotEmpty((CharSequence)this.taskRequest.getAppIds())) {
            this.setAppIds(this.taskRequest.getAppIds());
            this.trackApplicationStatus();
            return;
        }
        this.submitApplication();
        if (StringUtils.isNotEmpty((CharSequence)this.getAppIds())) {
            this.taskRequest.setAppIds(this.getAppIds());
            taskCallBack.updateRemoteApplicationInfo(this.taskRequest.getTaskInstanceId(), new ApplicationInfo(this.getAppIds()));
        }
        this.trackApplicationStatus();
    }

    public abstract void submitApplication() throws TaskException;

    public abstract void trackApplicationStatus() throws TaskException;
}

