/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.utils;

import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChannelUtils.class);

    private ChannelUtils() {
        throw new IllegalStateException(ChannelUtils.class.getName());
    }

    public static String getLocalAddress(Channel channel) {
        return NetUtils.getHost((InetAddress)((InetSocketAddress)channel.localAddress()).getAddress());
    }

    public static String getRemoteAddress(Channel channel) {
        return ChannelUtils.toAddress(channel).getAddress();
    }

    public static Host toAddress(Channel channel) {
        InetSocketAddress socketAddress = (InetSocketAddress)channel.remoteAddress();
        if (socketAddress == null) {
            log.warn("The channel is already closed");
            return Host.EMPTY;
        }
        return new Host(NetUtils.getHost((InetAddress)socketAddress.getAddress()), socketAddress.getPort());
    }
}

