/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.fluent.models.DiskUpdateProperties;
import com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.azure.resourcemanager.compute.models.DiskSku;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PropertyUpdatesInProgress;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class DiskUpdate {
    @JsonProperty(value="properties")
    private DiskUpdateProperties innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="sku")
    private DiskSku sku;

    private DiskUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DiskUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DiskSku sku() {
        return this.sku;
    }

    public DiskUpdate withSku(DiskSku sku) {
        this.sku = sku;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public DiskUpdate withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public Integer diskSizeGB() {
        return this.innerProperties() == null ? null : this.innerProperties().diskSizeGB();
    }

    public DiskUpdate withDiskSizeGB(Integer diskSizeGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDiskSizeGB(diskSizeGB);
        return this;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettingsCollection();
    }

    public DiskUpdate withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withEncryptionSettingsCollection(encryptionSettingsCollection);
        return this;
    }

    public Long diskIopsReadWrite() {
        return this.innerProperties() == null ? null : this.innerProperties().diskIopsReadWrite();
    }

    public DiskUpdate withDiskIopsReadWrite(Long diskIopsReadWrite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDiskIopsReadWrite(diskIopsReadWrite);
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.innerProperties() == null ? null : this.innerProperties().diskMBpsReadWrite();
    }

    public DiskUpdate withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDiskMBpsReadWrite(diskMBpsReadWrite);
        return this;
    }

    public Long diskIopsReadOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().diskIopsReadOnly();
    }

    public DiskUpdate withDiskIopsReadOnly(Long diskIopsReadOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDiskIopsReadOnly(diskIopsReadOnly);
        return this;
    }

    public Long diskMBpsReadOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().diskMBpsReadOnly();
    }

    public DiskUpdate withDiskMBpsReadOnly(Long diskMBpsReadOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDiskMBpsReadOnly(diskMBpsReadOnly);
        return this;
    }

    public Integer maxShares() {
        return this.innerProperties() == null ? null : this.innerProperties().maxShares();
    }

    public DiskUpdate withMaxShares(Integer maxShares) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withMaxShares(maxShares);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public DiskUpdate withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAccessPolicy();
    }

    public DiskUpdate withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withNetworkAccessPolicy(networkAccessPolicy);
        return this;
    }

    public String diskAccessId() {
        return this.innerProperties() == null ? null : this.innerProperties().diskAccessId();
    }

    public DiskUpdate withDiskAccessId(String diskAccessId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDiskAccessId(diskAccessId);
        return this;
    }

    public String tier() {
        return this.innerProperties() == null ? null : this.innerProperties().tier();
    }

    public DiskUpdate withTier(String tier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withTier(tier);
        return this;
    }

    public Boolean burstingEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().burstingEnabled();
    }

    public DiskUpdate withBurstingEnabled(Boolean burstingEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withBurstingEnabled(burstingEnabled);
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.innerProperties() == null ? null : this.innerProperties().purchasePlan();
    }

    public DiskUpdate withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withPurchasePlan(purchasePlan);
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().supportedCapabilities();
    }

    public DiskUpdate withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withSupportedCapabilities(supportedCapabilities);
        return this;
    }

    public PropertyUpdatesInProgress propertyUpdatesInProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().propertyUpdatesInProgress();
    }

    public Boolean supportsHibernation() {
        return this.innerProperties() == null ? null : this.innerProperties().supportsHibernation();
    }

    public DiskUpdate withSupportsHibernation(Boolean supportsHibernation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withSupportsHibernation(supportsHibernation);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public DiskUpdate withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public DataAccessAuthMode dataAccessAuthMode() {
        return this.innerProperties() == null ? null : this.innerProperties().dataAccessAuthMode();
    }

    public DiskUpdate withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withDataAccessAuthMode(dataAccessAuthMode);
        return this;
    }

    public Boolean optimizedForFrequentAttach() {
        return this.innerProperties() == null ? null : this.innerProperties().optimizedForFrequentAttach();
    }

    public DiskUpdate withOptimizedForFrequentAttach(Boolean optimizedForFrequentAttach) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskUpdateProperties();
        }
        this.innerProperties().withOptimizedForFrequentAttach(optimizedForFrequentAttach);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

