/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.dto.resources.CreateDirectoryDto;
import org.apache.dolphinscheduler.api.dto.resources.CreateDirectoryRequest;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileDto;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileFromContentDto;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileFromContentRequest;
import org.apache.dolphinscheduler.api.dto.resources.CreateFileRequest;
import org.apache.dolphinscheduler.api.dto.resources.DeleteResourceDto;
import org.apache.dolphinscheduler.api.dto.resources.DeleteResourceRequest;
import org.apache.dolphinscheduler.api.dto.resources.DownloadFileDto;
import org.apache.dolphinscheduler.api.dto.resources.DownloadFileRequest;
import org.apache.dolphinscheduler.api.dto.resources.FetchFileContentDto;
import org.apache.dolphinscheduler.api.dto.resources.FetchFileContentRequest;
import org.apache.dolphinscheduler.api.dto.resources.PagingResourceItemRequest;
import org.apache.dolphinscheduler.api.dto.resources.QueryResourceDto;
import org.apache.dolphinscheduler.api.dto.resources.RenameDirectoryDto;
import org.apache.dolphinscheduler.api.dto.resources.RenameDirectoryRequest;
import org.apache.dolphinscheduler.api.dto.resources.RenameFileDto;
import org.apache.dolphinscheduler.api.dto.resources.RenameFileRequest;
import org.apache.dolphinscheduler.api.dto.resources.ResourceComponent;
import org.apache.dolphinscheduler.api.dto.resources.UpdateFileDto;
import org.apache.dolphinscheduler.api.dto.resources.UpdateFileFromContentDto;
import org.apache.dolphinscheduler.api.dto.resources.UpdateFileFromContentRequest;
import org.apache.dolphinscheduler.api.dto.resources.UpdateFileRequest;
import org.apache.dolphinscheduler.api.dto.resources.visitor.ResourceTreeVisitor;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.validator.resource.CreateDirectoryDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.CreateDirectoryRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.CreateFileDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.CreateFileFromContentDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.DeleteResourceDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.DownloadFileDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.FetchFileContentDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.FileFromContentRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.FileRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.PagingResourceItemRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.RenameDirectoryDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.RenameDirectoryRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.RenameFileDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.RenameFileRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.UpdateFileDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.UpdateFileFromContentDtoValidator;
import org.apache.dolphinscheduler.api.validator.resource.UpdateFileFromContentRequestTransformer;
import org.apache.dolphinscheduler.api.validator.resource.UpdateFileRequestTransformer;
import org.apache.dolphinscheduler.api.vo.ResourceItemVO;
import org.apache.dolphinscheduler.api.vo.resources.FetchFileContentResponse;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourcesServiceImpl
extends BaseServiceImpl
implements ResourcesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcesServiceImpl.class);
    @Autowired
    private TenantDao tenantDao;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StorageOperator storageOperator;
    @Autowired
    private CreateDirectoryRequestTransformer createDirectoryRequestTransformer;
    @Autowired
    private CreateDirectoryDtoValidator createDirectoryDtoValidator;
    @Autowired
    private RenameDirectoryRequestTransformer renameDirectoryRequestTransformer;
    @Autowired
    private RenameDirectoryDtoValidator renameDirectoryDtoValidator;
    @Autowired
    private RenameFileRequestTransformer renameFileRequestTransformer;
    @Autowired
    private RenameFileDtoValidator renameFileDtoValidator;
    @Autowired
    private FileFromContentRequestTransformer createFileFromContentRequestTransformer;
    @Autowired
    private CreateFileFromContentDtoValidator createFileFromContentDtoValidator;
    @Autowired
    private FetchFileContentDtoValidator fetchFileContentDtoValidator;
    @Autowired
    private UpdateFileFromContentRequestTransformer updateFileFromContentRequestTransformer;
    @Autowired
    private UpdateFileFromContentDtoValidator updateFileFromContentDtoValidator;
    @Autowired
    private FileRequestTransformer createFileRequestTransformer;
    @Autowired
    private CreateFileDtoValidator createFileDtoValidator;
    @Autowired
    private UpdateFileRequestTransformer updateFileRequestTransformer;
    @Autowired
    private UpdateFileDtoValidator updateFileDtoValidator;
    @Autowired
    private DeleteResourceDtoValidator deleteResourceDtoValidator;
    @Autowired
    private DownloadFileDtoValidator downloadFileDtoValidator;
    @Autowired
    private PagingResourceItemRequestTransformer pagingResourceItemRequestTransformer;

    @Override
    public void createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        CreateDirectoryDto createDirectoryDto = this.createDirectoryRequestTransformer.transform(createDirectoryRequest);
        this.createDirectoryDtoValidator.validate(createDirectoryDto);
        this.storageOperator.createStorageDir(createDirectoryDto.getDirectoryAbsolutePath());
        log.info("Success create directory: {}", (Object)createDirectoryRequest.getParentAbsoluteDirectory());
    }

    @Override
    public void createFile(CreateFileRequest createFileRequest) {
        CreateFileDto createFileDto = this.createFileRequestTransformer.transform(createFileRequest);
        this.createFileDtoValidator.validate(createFileDto);
        MultipartFile file = createFileDto.getFile();
        String fileAbsolutePath = createFileDto.getFileAbsolutePath();
        String srcLocalTmpFileAbsolutePath = this.copyFileToLocal(file);
        try {
            this.storageOperator.upload(srcLocalTmpFileAbsolutePath, fileAbsolutePath, true, false);
            ApiServerMetrics.recordApiResourceUploadSize(file.getSize());
            log.info("Success upload resource file: {} complete.", (Object)fileAbsolutePath);
        }
        catch (Exception ex) {
            FileUtils.deleteFile((String)srcLocalTmpFileAbsolutePath);
            throw ex;
        }
    }

    @Override
    public void createFileFromContent(CreateFileFromContentRequest createFileFromContentRequest) {
        CreateFileFromContentDto createFileFromContentDto = this.createFileFromContentRequestTransformer.transform(createFileFromContentRequest);
        this.createFileFromContentDtoValidator.validate(createFileFromContentDto);
        String fileContent = createFileFromContentDto.getFileContent();
        String fileAbsolutePath = createFileFromContentDto.getFileAbsolutePath();
        String srcLocalTmpFileAbsolutePath = this.copyFileToLocal(fileContent);
        try {
            this.storageOperator.upload(srcLocalTmpFileAbsolutePath, fileAbsolutePath, true, false);
            ApiServerMetrics.recordApiResourceUploadSize(fileContent.length());
            log.info("Success upload resource file: {} complete.", (Object)fileAbsolutePath);
        }
        catch (Exception ex) {
            FileUtils.deleteFile((String)srcLocalTmpFileAbsolutePath);
            throw ex;
        }
    }

    @Override
    public void renameDirectory(RenameDirectoryRequest renameDirectoryRequest) {
        RenameDirectoryDto renameDirectoryDto = this.renameDirectoryRequestTransformer.transform(renameDirectoryRequest);
        this.renameDirectoryDtoValidator.validate(renameDirectoryDto);
        String originDirectoryAbsolutePath = renameDirectoryDto.getOriginDirectoryAbsolutePath();
        String targetDirectoryAbsolutePath = renameDirectoryDto.getTargetDirectoryAbsolutePath();
        this.storageOperator.copy(originDirectoryAbsolutePath, targetDirectoryAbsolutePath, true, true);
        log.info("Success rename directory: {} -> {} ", (Object)originDirectoryAbsolutePath, (Object)targetDirectoryAbsolutePath);
    }

    @Override
    public void renameFile(RenameFileRequest renameFileRequest) {
        RenameFileDto renameFileDto = this.renameFileRequestTransformer.transform(renameFileRequest);
        this.renameFileDtoValidator.validate(renameFileDto);
        String originFileAbsolutePath = renameFileDto.getOriginFileAbsolutePath();
        String targetFileAbsolutePath = renameFileDto.getTargetFileAbsolutePath();
        this.storageOperator.copy(originFileAbsolutePath, targetFileAbsolutePath, true, true);
        log.info("Success rename file: {} -> {} ", (Object)originFileAbsolutePath, (Object)targetFileAbsolutePath);
    }

    @Override
    public void updateFile(UpdateFileRequest updateFileRequest) {
        UpdateFileDto updateFileDto = this.updateFileRequestTransformer.transform(updateFileRequest);
        this.updateFileDtoValidator.validate(updateFileDto);
        String srcLocalTmpFileAbsolutePath = this.copyFileToLocal(updateFileDto.getFile());
        try {
            this.storageOperator.upload(srcLocalTmpFileAbsolutePath, updateFileDto.getFileAbsolutePath(), true, true);
            ApiServerMetrics.recordApiResourceUploadSize(updateFileDto.getFile().getSize());
            log.info("Success upload resource file: {} complete.", (Object)updateFileDto.getFileAbsolutePath());
        }
        catch (Exception ex) {
            FileUtils.deleteFile((String)srcLocalTmpFileAbsolutePath);
            throw ex;
        }
    }

    @Override
    public PageInfo<ResourceItemVO> pagingResourceItem(PagingResourceItemRequest pagingResourceItemRequest) {
        QueryResourceDto queryResourceDto = this.pagingResourceItemRequestTransformer.transform(pagingResourceItemRequest);
        List<String> resourceAbsolutePaths = queryResourceDto.getResourceAbsolutePaths();
        if (CollectionUtils.isEmpty(resourceAbsolutePaths)) {
            return new PageInfo<ResourceItemVO>(pagingResourceItemRequest.getPageNo(), pagingResourceItemRequest.getPageSize());
        }
        for (String resourceAbsolutePath2 : resourceAbsolutePaths) {
            this.createDirectoryDtoValidator.exceptionResourceAbsolutePathInvalidated(resourceAbsolutePath2);
            this.createDirectoryDtoValidator.exceptionUserNoResourcePermission(pagingResourceItemRequest.getLoginUser(), resourceAbsolutePath2);
        }
        Integer pageNo = pagingResourceItemRequest.getPageNo();
        Integer pageSize = pagingResourceItemRequest.getPageSize();
        List storageEntities = resourceAbsolutePaths.stream().flatMap(resourceAbsolutePath -> this.storageOperator.listStorageEntity(resourceAbsolutePath).stream()).collect(Collectors.toList());
        List result = storageEntities.stream().filter(storageEntity -> storageEntity.getFileName().contains(pagingResourceItemRequest.getResourceNameKeyWord())).skip((long)(pageNo - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).map(ResourceItemVO::new).collect(Collectors.toList());
        return PageInfo.builder().pageNo(pagingResourceItemRequest.getPageNo()).pageSize(pagingResourceItemRequest.getPageSize()).total(storageEntities.size()).totalList(result).build();
    }

    @Override
    public List<ResourceComponent> queryResourceFiles(User loginUser, ResourceType resourceType) {
        Tenant tenant = (Tenant)this.tenantDao.queryOptionalById((Serializable)Integer.valueOf(loginUser.getTenantId())).orElseThrow(() -> new ServiceException(Status.TENANT_NOT_EXIST, loginUser.getTenantId()));
        String storageBaseDirectory = this.storageOperator.getStorageBaseDirectory(tenant.getTenantCode(), resourceType);
        List allResourceFiles = this.storageOperator.listFileStorageEntityRecursively(storageBaseDirectory);
        ResourceTreeVisitor visitor = new ResourceTreeVisitor(allResourceFiles);
        return visitor.visit("").getChildren();
    }

    @Override
    public void delete(DeleteResourceRequest deleteResourceRequest) {
        DeleteResourceDto deleteResourceDto = DeleteResourceDto.builder().loginUser(deleteResourceRequest.getLoginUser()).resourceAbsolutePath(deleteResourceRequest.getResourceAbsolutePath()).build();
        this.deleteResourceDtoValidator.validate(deleteResourceDto);
        this.storageOperator.delete(deleteResourceDto.getResourceAbsolutePath(), true);
    }

    @Override
    public FetchFileContentResponse fetchResourceFileContent(FetchFileContentRequest fetchFileContentRequest) {
        FetchFileContentDto fetchFileContentDto = FetchFileContentDto.builder().loginUser(fetchFileContentRequest.getLoginUser()).resourceFileAbsolutePath(fetchFileContentRequest.getResourceFileAbsolutePath()).skipLineNum(fetchFileContentRequest.getSkipLineNum()).limit(fetchFileContentRequest.getLimit()).build();
        this.fetchFileContentDtoValidator.validate(fetchFileContentDto);
        String content = this.storageOperator.fetchFileContent(fetchFileContentRequest.getResourceFileAbsolutePath(), fetchFileContentRequest.getSkipLineNum(), fetchFileContentRequest.getLimit()).stream().collect(Collectors.joining("\n"));
        ApiServerMetrics.recordApiResourceDownloadSize(content.length());
        return FetchFileContentResponse.builder().content(content).build();
    }

    @Override
    public void updateFileFromContent(UpdateFileFromContentRequest updateFileContentRequest) {
        UpdateFileFromContentDto updateFileFromContentDto = this.updateFileFromContentRequestTransformer.transform(updateFileContentRequest);
        this.updateFileFromContentDtoValidator.validate(updateFileFromContentDto);
        String srcLocalTmpFileAbsolutePath = this.copyFileToLocal(updateFileFromContentDto.getFileContent());
        try {
            this.storageOperator.upload(srcLocalTmpFileAbsolutePath, updateFileFromContentDto.getFileAbsolutePath(), true, true);
            ApiServerMetrics.recordApiResourceUploadSize(updateFileFromContentDto.getFileContent().length());
            log.info("Success upload resource file: {} complete.", (Object)updateFileFromContentDto.getFileAbsolutePath());
        }
        catch (Exception ex) {
            FileUtils.deleteFile((String)srcLocalTmpFileAbsolutePath);
            throw new ServiceException("Update the resource file from content: " + updateFileFromContentDto.getFileAbsolutePath() + " failed", ex);
        }
    }

    @Override
    public void downloadResource(HttpServletResponse response, DownloadFileRequest downloadFileRequest) {
        DownloadFileDto downloadFileDto = DownloadFileDto.builder().loginUser(downloadFileRequest.getLoginUser()).fileAbsolutePath(downloadFileRequest.getFileAbsolutePath()).build();
        this.downloadFileDtoValidator.validate(downloadFileDto);
        String fileName = new File(downloadFileDto.getFileAbsolutePath()).getName();
        String localTmpFileAbsolutePath = FileUtils.getDownloadFilename((String)fileName);
        try {
            this.storageOperator.download(downloadFileRequest.getFileAbsolutePath(), localTmpFileAbsolutePath, true);
            int length = (int)new File(localTmpFileAbsolutePath).length();
            ApiServerMetrics.recordApiResourceDownloadSize(length);
            response.reset();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("utf-8");
            response.setContentLength(length);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            Files.copy(Paths.get(localTmpFileAbsolutePath, new String[0]), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new ServiceException("Download the resource file: " + downloadFileRequest.getFileAbsolutePath() + " failed", e);
        }
        finally {
            FileUtils.deleteFile((String)localTmpFileAbsolutePath);
        }
    }

    @Override
    public StorageEntity queryFileStatus(String userName, String fileAbsolutePath) {
        return this.storageOperator.getStorageEntity(fileAbsolutePath);
    }

    @Override
    public String queryResourceBaseDir(User loginUser, ResourceType type) {
        User user = (User)this.userMapper.selectById((Serializable)loginUser.getId());
        if (user == null) {
            throw new ServiceException(Status.USER_NOT_EXIST);
        }
        Tenant tenant = (Tenant)this.tenantDao.queryOptionalById((Serializable)Integer.valueOf(user.getTenantId())).orElseThrow(() -> new ServiceException(Status.CURRENT_LOGIN_USER_TENANT_NOT_EXIST));
        return this.storageOperator.getStorageBaseDirectory(tenant.getTenantCode(), type);
    }

    private String copyFileToLocal(MultipartFile multipartFile) {
        String localTmpFileAbsolutePath = FileUtils.getUploadFileLocalTmpAbsolutePath();
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (String)localTmpFileAbsolutePath);
        return localTmpFileAbsolutePath;
    }

    private String copyFileToLocal(String fileContent) {
        String localTmpFileAbsolutePath = FileUtils.getUploadFileLocalTmpAbsolutePath();
        FileUtils.writeContent2File((String)fileContent, (String)localTmpFileAbsolutePath);
        return localTmpFileAbsolutePath;
    }
}

