/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.PagingResourceItemRequest;
import org.apache.dolphinscheduler.api.dto.resources.QueryResourceDto;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.springframework.stereotype.Component;

@Component
public class PagingResourceItemRequestTransformer
implements ITransformer<PagingResourceItemRequest, QueryResourceDto> {
    private final StorageOperator storageOperator;
    private final TenantDao tenantDao;

    @Override
    public QueryResourceDto transform(PagingResourceItemRequest pagingResourceItemRequest) {
        this.validatePagingResourceItemRequest(pagingResourceItemRequest);
        if (StringUtils.isNotEmpty((CharSequence)pagingResourceItemRequest.getResourceAbsolutePath())) {
            return QueryResourceDto.builder().resourceAbsolutePaths(Lists.newArrayList((Object[])new String[]{pagingResourceItemRequest.getResourceAbsolutePath()})).build();
        }
        ResourceType resourceType = pagingResourceItemRequest.getResourceType();
        User loginUser = pagingResourceItemRequest.getLoginUser();
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            List<String> resourceAbsolutePaths = this.tenantDao.queryAll().stream().map(tenant -> this.storageOperator.getStorageBaseDirectory(tenant.getTenantCode(), resourceType)).collect(Collectors.toList());
            return QueryResourceDto.builder().resourceAbsolutePaths(resourceAbsolutePaths).build();
        }
        Tenant tenant2 = (Tenant)this.tenantDao.queryById((Serializable)Integer.valueOf(loginUser.getTenantId()));
        String storageBaseDirectory = this.storageOperator.getStorageBaseDirectory(tenant2.getTenantCode(), resourceType);
        return QueryResourceDto.builder().resourceAbsolutePaths(Lists.newArrayList((Object[])new String[]{storageBaseDirectory})).build();
    }

    private void validatePagingResourceItemRequest(PagingResourceItemRequest pagingResourceItemRequest) {
        Preconditions.checkNotNull((Object)pagingResourceItemRequest.getLoginUser(), (Object)"loginUser is null");
        Preconditions.checkNotNull((Object)pagingResourceItemRequest.getResourceType(), (Object)"resourceType is null");
    }

    @Generated
    public PagingResourceItemRequestTransformer(StorageOperator storageOperator, TenantDao tenantDao) {
        this.storageOperator = storageOperator;
        this.tenantDao = tenantDao;
    }
}

