/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.ModelMapper;
import io.kubernetes.client.util.generic.GenericKubernetesApi;

public class KubectlPatch<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlPatch<ApiType>>
implements Kubectl.Executable<ApiType> {
    private String patchType;
    private V1Patch patchContent;

    KubectlPatch(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlPatch patchContent(V1Patch patchContent) {
        this.patchContent = patchContent;
        return this;
    }

    public KubectlPatch patchType(String patchType) {
        this.patchType = patchType;
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        this.refreshDiscovery();
        GenericKubernetesApi genericKubernetesApi = this.getGenericApi();
        try {
            if (ModelMapper.isNamespaced((Class)this.apiTypeClass).booleanValue()) {
                return (ApiType)((KubernetesObject)genericKubernetesApi.patch(this.namespace, this.name, this.patchType, this.patchContent).throwsApiException().getObject());
            }
            return (ApiType)((KubernetesObject)genericKubernetesApi.patch(this.name, this.patchType, this.patchContent).throwsApiException().getObject());
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }
}

