/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.databasemigrationservice.model.TableStatistics;
import java.util.Date;

@SdkInternalApi
public class TableStatisticsMarshaller {
    private static final MarshallingInfo<String> SCHEMANAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<Long> INSERTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inserts").build();
    private static final MarshallingInfo<Long> DELETES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deletes").build();
    private static final MarshallingInfo<Long> UPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Updates").build();
    private static final MarshallingInfo<Long> DDLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ddls").build();
    private static final MarshallingInfo<Long> FULLLOADROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadRows").build();
    private static final MarshallingInfo<Long> FULLLOADCONDTNLCHKFAILEDROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadCondtnlChkFailedRows").build();
    private static final MarshallingInfo<Long> FULLLOADERRORROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadErrorRows").build();
    private static final MarshallingInfo<Date> FULLLOADSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> FULLLOADENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Boolean> FULLLOADRELOADED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullLoadReloaded").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> TABLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableState").build();
    private static final MarshallingInfo<Long> VALIDATIONPENDINGRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationPendingRecords").build();
    private static final MarshallingInfo<Long> VALIDATIONFAILEDRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationFailedRecords").build();
    private static final MarshallingInfo<Long> VALIDATIONSUSPENDEDRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationSuspendedRecords").build();
    private static final MarshallingInfo<String> VALIDATIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationState").build();
    private static final MarshallingInfo<String> VALIDATIONSTATEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationStateDetails").build();
    private static final TableStatisticsMarshaller instance = new TableStatisticsMarshaller();

    public static TableStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableStatistics tableStatistics, ProtocolMarshaller protocolMarshaller) {
        if (tableStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tableStatistics.getSchemaName(), SCHEMANAME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getInserts(), INSERTS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getDeletes(), DELETES_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getUpdates(), UPDATES_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getDdls(), DDLS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getFullLoadRows(), FULLLOADROWS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getFullLoadCondtnlChkFailedRows(), FULLLOADCONDTNLCHKFAILEDROWS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getFullLoadErrorRows(), FULLLOADERRORROWS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getFullLoadStartTime(), FULLLOADSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getFullLoadEndTime(), FULLLOADENDTIME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getFullLoadReloaded(), FULLLOADRELOADED_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getTableState(), TABLESTATE_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getValidationPendingRecords(), VALIDATIONPENDINGRECORDS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getValidationFailedRecords(), VALIDATIONFAILEDRECORDS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getValidationSuspendedRecords(), VALIDATIONSUSPENDEDRECORDS_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getValidationState(), VALIDATIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)tableStatistics.getValidationStateDetails(), VALIDATIONSTATEDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

