/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.CancelResumableWriteRequest;
import com.google.storage.v2.CancelResumableWriteResponse;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.CreateHmacKeyRequest;
import com.google.storage.v2.CreateHmacKeyResponse;
import com.google.storage.v2.CreateNotificationRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteHmacKeyRequest;
import com.google.storage.v2.DeleteNotificationRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetHmacKeyRequest;
import com.google.storage.v2.GetNotificationRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.GetServiceAccountRequest;
import com.google.storage.v2.HmacKeyMetadata;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListBucketsResponse;
import com.google.storage.v2.ListHmacKeysRequest;
import com.google.storage.v2.ListHmacKeysResponse;
import com.google.storage.v2.ListNotificationsRequest;
import com.google.storage.v2.ListNotificationsResponse;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.ListObjectsResponse;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.Notification;
import com.google.storage.v2.Object;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.RewriteResponse;
import com.google.storage.v2.ServiceAccount;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageClient;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateHmacKeyRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.GrpcStorageStub;
import com.google.storage.v2.stub.StorageStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class StorageStubSettings
extends StubSettings<StorageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((java.lang.Object)"https://www.googleapis.com/auth/cloud-platform").add((java.lang.Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((java.lang.Object)"https://www.googleapis.com/auth/devstorage.full_control").add((java.lang.Object)"https://www.googleapis.com/auth/devstorage.read_only").add((java.lang.Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteBucketRequest, Empty> deleteBucketSettings;
    private final UnaryCallSettings<GetBucketRequest, Bucket> getBucketSettings;
    private final UnaryCallSettings<CreateBucketRequest, Bucket> createBucketSettings;
    private final PagedCallSettings<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings;
    private final UnaryCallSettings<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateBucketRequest, Bucket> updateBucketSettings;
    private final UnaryCallSettings<DeleteNotificationRequest, Empty> deleteNotificationSettings;
    private final UnaryCallSettings<GetNotificationRequest, Notification> getNotificationSettings;
    private final UnaryCallSettings<CreateNotificationRequest, Notification> createNotificationSettings;
    private final PagedCallSettings<ListNotificationsRequest, ListNotificationsResponse, StorageClient.ListNotificationsPagedResponse> listNotificationsSettings;
    private final UnaryCallSettings<ComposeObjectRequest, Object> composeObjectSettings;
    private final UnaryCallSettings<DeleteObjectRequest, Empty> deleteObjectSettings;
    private final UnaryCallSettings<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings;
    private final UnaryCallSettings<GetObjectRequest, Object> getObjectSettings;
    private final ServerStreamingCallSettings<ReadObjectRequest, ReadObjectResponse> readObjectSettings;
    private final UnaryCallSettings<UpdateObjectRequest, Object> updateObjectSettings;
    private final StreamingCallSettings<WriteObjectRequest, WriteObjectResponse> writeObjectSettings;
    private final PagedCallSettings<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings;
    private final UnaryCallSettings<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings;
    private final UnaryCallSettings<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings;
    private final UnaryCallSettings<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings;
    private final UnaryCallSettings<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings;
    private final UnaryCallSettings<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeySettings;
    private final UnaryCallSettings<DeleteHmacKeyRequest, Empty> deleteHmacKeySettings;
    private final UnaryCallSettings<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeySettings;
    private final PagedCallSettings<ListHmacKeysRequest, ListHmacKeysResponse, StorageClient.ListHmacKeysPagedResponse> listHmacKeysSettings;
    private final UnaryCallSettings<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeySettings;
    private static final PagedListDescriptor<ListBucketsRequest, ListBucketsResponse, Bucket> LIST_BUCKETS_PAGE_STR_DESC = new PagedListDescriptor<ListBucketsRequest, ListBucketsResponse, Bucket>(){

        public String emptyToken() {
            return "";
        }

        public ListBucketsRequest injectToken(ListBucketsRequest payload, String token) {
            return ListBucketsRequest.newBuilder((ListBucketsRequest)payload).setPageToken(token).build();
        }

        public ListBucketsRequest injectPageSize(ListBucketsRequest payload, int pageSize) {
            return ListBucketsRequest.newBuilder((ListBucketsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBucketsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBucketsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Bucket> extractResources(ListBucketsResponse payload) {
            return payload.getBucketsList() == null ? ImmutableList.of() : payload.getBucketsList();
        }
    };
    private static final PagedListDescriptor<ListNotificationsRequest, ListNotificationsResponse, Notification> LIST_NOTIFICATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListNotificationsRequest, ListNotificationsResponse, Notification>(){

        public String emptyToken() {
            return "";
        }

        public ListNotificationsRequest injectToken(ListNotificationsRequest payload, String token) {
            return ListNotificationsRequest.newBuilder((ListNotificationsRequest)payload).setPageToken(token).build();
        }

        public ListNotificationsRequest injectPageSize(ListNotificationsRequest payload, int pageSize) {
            return ListNotificationsRequest.newBuilder((ListNotificationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNotificationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNotificationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Notification> extractResources(ListNotificationsResponse payload) {
            return payload.getNotificationsList() == null ? ImmutableList.of() : payload.getNotificationsList();
        }
    };
    private static final PagedListDescriptor<ListObjectsRequest, ListObjectsResponse, Object> LIST_OBJECTS_PAGE_STR_DESC = new PagedListDescriptor<ListObjectsRequest, ListObjectsResponse, Object>(){

        public String emptyToken() {
            return "";
        }

        public ListObjectsRequest injectToken(ListObjectsRequest payload, String token) {
            return ListObjectsRequest.newBuilder((ListObjectsRequest)payload).setPageToken(token).build();
        }

        public ListObjectsRequest injectPageSize(ListObjectsRequest payload, int pageSize) {
            return ListObjectsRequest.newBuilder((ListObjectsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListObjectsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListObjectsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Object> extractResources(ListObjectsResponse payload) {
            return payload.getObjectsList() == null ? ImmutableList.of() : payload.getObjectsList();
        }
    };
    private static final PagedListDescriptor<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata> LIST_HMAC_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata>(){

        public String emptyToken() {
            return "";
        }

        public ListHmacKeysRequest injectToken(ListHmacKeysRequest payload, String token) {
            return ListHmacKeysRequest.newBuilder((ListHmacKeysRequest)payload).setPageToken(token).build();
        }

        public ListHmacKeysRequest injectPageSize(ListHmacKeysRequest payload, int pageSize) {
            return ListHmacKeysRequest.newBuilder((ListHmacKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHmacKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHmacKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HmacKeyMetadata> extractResources(ListHmacKeysResponse payload) {
            return payload.getHmacKeysList() == null ? ImmutableList.of() : payload.getHmacKeysList();
        }
    };
    private static final PagedListResponseFactory<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> LIST_BUCKETS_PAGE_STR_FACT = new PagedListResponseFactory<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse>(){

        public ApiFuture<StorageClient.ListBucketsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBucketsRequest, ListBucketsResponse> callable, ListBucketsRequest request, ApiCallContext context, ApiFuture<ListBucketsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BUCKETS_PAGE_STR_DESC, (java.lang.Object)request, (ApiCallContext)context);
            return StorageClient.ListBucketsPagedResponse.createAsync((PageContext<ListBucketsRequest, ListBucketsResponse, Bucket>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNotificationsRequest, ListNotificationsResponse, StorageClient.ListNotificationsPagedResponse> LIST_NOTIFICATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListNotificationsRequest, ListNotificationsResponse, StorageClient.ListNotificationsPagedResponse>(){

        public ApiFuture<StorageClient.ListNotificationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> callable, ListNotificationsRequest request, ApiCallContext context, ApiFuture<ListNotificationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NOTIFICATIONS_PAGE_STR_DESC, (java.lang.Object)request, (ApiCallContext)context);
            return StorageClient.ListNotificationsPagedResponse.createAsync((PageContext<ListNotificationsRequest, ListNotificationsResponse, Notification>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> LIST_OBJECTS_PAGE_STR_FACT = new PagedListResponseFactory<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse>(){

        public ApiFuture<StorageClient.ListObjectsPagedResponse> getFuturePagedResponse(UnaryCallable<ListObjectsRequest, ListObjectsResponse> callable, ListObjectsRequest request, ApiCallContext context, ApiFuture<ListObjectsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_OBJECTS_PAGE_STR_DESC, (java.lang.Object)request, (ApiCallContext)context);
            return StorageClient.ListObjectsPagedResponse.createAsync((PageContext<ListObjectsRequest, ListObjectsResponse, Object>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListHmacKeysRequest, ListHmacKeysResponse, StorageClient.ListHmacKeysPagedResponse> LIST_HMAC_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListHmacKeysRequest, ListHmacKeysResponse, StorageClient.ListHmacKeysPagedResponse>(){

        public ApiFuture<StorageClient.ListHmacKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListHmacKeysRequest, ListHmacKeysResponse> callable, ListHmacKeysRequest request, ApiCallContext context, ApiFuture<ListHmacKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HMAC_KEYS_PAGE_STR_DESC, (java.lang.Object)request, (ApiCallContext)context);
            return StorageClient.ListHmacKeysPagedResponse.createAsync((PageContext<ListHmacKeysRequest, ListHmacKeysResponse, HmacKeyMetadata>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteBucketRequest, Empty> deleteBucketSettings() {
        return this.deleteBucketSettings;
    }

    public UnaryCallSettings<GetBucketRequest, Bucket> getBucketSettings() {
        return this.getBucketSettings;
    }

    public UnaryCallSettings<CreateBucketRequest, Bucket> createBucketSettings() {
        return this.createBucketSettings;
    }

    public PagedCallSettings<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings() {
        return this.listBucketsSettings;
    }

    public UnaryCallSettings<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings() {
        return this.lockBucketRetentionPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateBucketRequest, Bucket> updateBucketSettings() {
        return this.updateBucketSettings;
    }

    public UnaryCallSettings<DeleteNotificationRequest, Empty> deleteNotificationSettings() {
        return this.deleteNotificationSettings;
    }

    public UnaryCallSettings<GetNotificationRequest, Notification> getNotificationSettings() {
        return this.getNotificationSettings;
    }

    public UnaryCallSettings<CreateNotificationRequest, Notification> createNotificationSettings() {
        return this.createNotificationSettings;
    }

    public PagedCallSettings<ListNotificationsRequest, ListNotificationsResponse, StorageClient.ListNotificationsPagedResponse> listNotificationsSettings() {
        return this.listNotificationsSettings;
    }

    public UnaryCallSettings<ComposeObjectRequest, Object> composeObjectSettings() {
        return this.composeObjectSettings;
    }

    public UnaryCallSettings<DeleteObjectRequest, Empty> deleteObjectSettings() {
        return this.deleteObjectSettings;
    }

    public UnaryCallSettings<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings() {
        return this.cancelResumableWriteSettings;
    }

    public UnaryCallSettings<GetObjectRequest, Object> getObjectSettings() {
        return this.getObjectSettings;
    }

    public ServerStreamingCallSettings<ReadObjectRequest, ReadObjectResponse> readObjectSettings() {
        return this.readObjectSettings;
    }

    public UnaryCallSettings<UpdateObjectRequest, Object> updateObjectSettings() {
        return this.updateObjectSettings;
    }

    public StreamingCallSettings<WriteObjectRequest, WriteObjectResponse> writeObjectSettings() {
        return this.writeObjectSettings;
    }

    public PagedCallSettings<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings() {
        return this.listObjectsSettings;
    }

    public UnaryCallSettings<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings() {
        return this.rewriteObjectSettings;
    }

    public UnaryCallSettings<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings() {
        return this.startResumableWriteSettings;
    }

    public UnaryCallSettings<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings() {
        return this.queryWriteStatusSettings;
    }

    public UnaryCallSettings<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings() {
        return this.getServiceAccountSettings;
    }

    public UnaryCallSettings<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeySettings() {
        return this.createHmacKeySettings;
    }

    public UnaryCallSettings<DeleteHmacKeyRequest, Empty> deleteHmacKeySettings() {
        return this.deleteHmacKeySettings;
    }

    public UnaryCallSettings<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeySettings() {
        return this.getHmacKeySettings;
    }

    public PagedCallSettings<ListHmacKeysRequest, ListHmacKeysResponse, StorageClient.ListHmacKeysPagedResponse> listHmacKeysSettings() {
        return this.listHmacKeysSettings;
    }

    public UnaryCallSettings<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeySettings() {
        return this.updateHmacKeySettings;
    }

    public StorageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStorageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "storage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "storage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StorageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StorageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteBucketSettings = settingsBuilder.deleteBucketSettings().build();
        this.getBucketSettings = settingsBuilder.getBucketSettings().build();
        this.createBucketSettings = settingsBuilder.createBucketSettings().build();
        this.listBucketsSettings = settingsBuilder.listBucketsSettings().build();
        this.lockBucketRetentionPolicySettings = settingsBuilder.lockBucketRetentionPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateBucketSettings = settingsBuilder.updateBucketSettings().build();
        this.deleteNotificationSettings = settingsBuilder.deleteNotificationSettings().build();
        this.getNotificationSettings = settingsBuilder.getNotificationSettings().build();
        this.createNotificationSettings = settingsBuilder.createNotificationSettings().build();
        this.listNotificationsSettings = settingsBuilder.listNotificationsSettings().build();
        this.composeObjectSettings = settingsBuilder.composeObjectSettings().build();
        this.deleteObjectSettings = settingsBuilder.deleteObjectSettings().build();
        this.cancelResumableWriteSettings = settingsBuilder.cancelResumableWriteSettings().build();
        this.getObjectSettings = settingsBuilder.getObjectSettings().build();
        this.readObjectSettings = settingsBuilder.readObjectSettings().build();
        this.updateObjectSettings = settingsBuilder.updateObjectSettings().build();
        this.writeObjectSettings = settingsBuilder.writeObjectSettings().build();
        this.listObjectsSettings = settingsBuilder.listObjectsSettings().build();
        this.rewriteObjectSettings = settingsBuilder.rewriteObjectSettings().build();
        this.startResumableWriteSettings = settingsBuilder.startResumableWriteSettings().build();
        this.queryWriteStatusSettings = settingsBuilder.queryWriteStatusSettings().build();
        this.getServiceAccountSettings = settingsBuilder.getServiceAccountSettings().build();
        this.createHmacKeySettings = settingsBuilder.createHmacKeySettings().build();
        this.deleteHmacKeySettings = settingsBuilder.deleteHmacKeySettings().build();
        this.getHmacKeySettings = settingsBuilder.getHmacKeySettings().build();
        this.listHmacKeysSettings = settingsBuilder.listHmacKeysSettings().build();
        this.updateHmacKeySettings = settingsBuilder.updateHmacKeySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StorageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteBucketRequest, Empty> deleteBucketSettings;
        private final UnaryCallSettings.Builder<GetBucketRequest, Bucket> getBucketSettings;
        private final UnaryCallSettings.Builder<CreateBucketRequest, Bucket> createBucketSettings;
        private final PagedCallSettings.Builder<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings;
        private final UnaryCallSettings.Builder<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateBucketRequest, Bucket> updateBucketSettings;
        private final UnaryCallSettings.Builder<DeleteNotificationRequest, Empty> deleteNotificationSettings;
        private final UnaryCallSettings.Builder<GetNotificationRequest, Notification> getNotificationSettings;
        private final UnaryCallSettings.Builder<CreateNotificationRequest, Notification> createNotificationSettings;
        private final PagedCallSettings.Builder<ListNotificationsRequest, ListNotificationsResponse, StorageClient.ListNotificationsPagedResponse> listNotificationsSettings;
        private final UnaryCallSettings.Builder<ComposeObjectRequest, Object> composeObjectSettings;
        private final UnaryCallSettings.Builder<DeleteObjectRequest, Empty> deleteObjectSettings;
        private final UnaryCallSettings.Builder<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings;
        private final UnaryCallSettings.Builder<GetObjectRequest, Object> getObjectSettings;
        private final ServerStreamingCallSettings.Builder<ReadObjectRequest, ReadObjectResponse> readObjectSettings;
        private final UnaryCallSettings.Builder<UpdateObjectRequest, Object> updateObjectSettings;
        private final StreamingCallSettings.Builder<WriteObjectRequest, WriteObjectResponse> writeObjectSettings;
        private final PagedCallSettings.Builder<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings;
        private final UnaryCallSettings.Builder<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings;
        private final UnaryCallSettings.Builder<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings;
        private final UnaryCallSettings.Builder<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings;
        private final UnaryCallSettings.Builder<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings;
        private final UnaryCallSettings.Builder<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeySettings;
        private final UnaryCallSettings.Builder<DeleteHmacKeyRequest, Empty> deleteHmacKeySettings;
        private final UnaryCallSettings.Builder<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeySettings;
        private final PagedCallSettings.Builder<ListHmacKeysRequest, ListHmacKeysResponse, StorageClient.ListHmacKeysPagedResponse> listHmacKeysSettings;
        private final UnaryCallSettings.Builder<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBucketsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BUCKETS_PAGE_STR_FACT);
            this.lockBucketRetentionPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNotificationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNotificationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNotificationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNotificationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NOTIFICATIONS_PAGE_STR_FACT);
            this.composeObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelResumableWriteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readObjectSettings = ServerStreamingCallSettings.newBuilder();
            this.updateObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.writeObjectSettings = StreamingCallSettings.newBuilder();
            this.listObjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_OBJECTS_PAGE_STR_FACT);
            this.rewriteObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startResumableWriteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryWriteStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHmacKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteHmacKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHmacKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listHmacKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HMAC_KEYS_PAGE_STR_FACT);
            this.updateHmacKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteBucketSettings, this.getBucketSettings, this.createBucketSettings, this.listBucketsSettings, this.lockBucketRetentionPolicySettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateBucketSettings, this.deleteNotificationSettings, this.getNotificationSettings, this.createNotificationSettings, (java.lang.Object[])new UnaryCallSettings.Builder[]{this.listNotificationsSettings, this.composeObjectSettings, this.deleteObjectSettings, this.cancelResumableWriteSettings, this.getObjectSettings, this.updateObjectSettings, this.listObjectsSettings, this.rewriteObjectSettings, this.startResumableWriteSettings, this.queryWriteStatusSettings, this.getServiceAccountSettings, this.createHmacKeySettings, this.deleteHmacKeySettings, this.getHmacKeySettings, this.listHmacKeysSettings, this.updateHmacKeySettings});
            Builder.initDefaults(this);
        }

        protected Builder(StorageStubSettings settings) {
            super((StubSettings)settings);
            this.deleteBucketSettings = settings.deleteBucketSettings.toBuilder();
            this.getBucketSettings = settings.getBucketSettings.toBuilder();
            this.createBucketSettings = settings.createBucketSettings.toBuilder();
            this.listBucketsSettings = settings.listBucketsSettings.toBuilder();
            this.lockBucketRetentionPolicySettings = settings.lockBucketRetentionPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateBucketSettings = settings.updateBucketSettings.toBuilder();
            this.deleteNotificationSettings = settings.deleteNotificationSettings.toBuilder();
            this.getNotificationSettings = settings.getNotificationSettings.toBuilder();
            this.createNotificationSettings = settings.createNotificationSettings.toBuilder();
            this.listNotificationsSettings = settings.listNotificationsSettings.toBuilder();
            this.composeObjectSettings = settings.composeObjectSettings.toBuilder();
            this.deleteObjectSettings = settings.deleteObjectSettings.toBuilder();
            this.cancelResumableWriteSettings = settings.cancelResumableWriteSettings.toBuilder();
            this.getObjectSettings = settings.getObjectSettings.toBuilder();
            this.readObjectSettings = settings.readObjectSettings.toBuilder();
            this.updateObjectSettings = settings.updateObjectSettings.toBuilder();
            this.writeObjectSettings = settings.writeObjectSettings.toBuilder();
            this.listObjectsSettings = settings.listObjectsSettings.toBuilder();
            this.rewriteObjectSettings = settings.rewriteObjectSettings.toBuilder();
            this.startResumableWriteSettings = settings.startResumableWriteSettings.toBuilder();
            this.queryWriteStatusSettings = settings.queryWriteStatusSettings.toBuilder();
            this.getServiceAccountSettings = settings.getServiceAccountSettings.toBuilder();
            this.createHmacKeySettings = settings.createHmacKeySettings.toBuilder();
            this.deleteHmacKeySettings = settings.deleteHmacKeySettings.toBuilder();
            this.getHmacKeySettings = settings.getHmacKeySettings.toBuilder();
            this.listHmacKeysSettings = settings.listHmacKeysSettings.toBuilder();
            this.updateHmacKeySettings = settings.updateHmacKeySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteBucketSettings, this.getBucketSettings, this.createBucketSettings, this.listBucketsSettings, this.lockBucketRetentionPolicySettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateBucketSettings, this.deleteNotificationSettings, this.getNotificationSettings, this.createNotificationSettings, (java.lang.Object[])new UnaryCallSettings.Builder[]{this.listNotificationsSettings, this.composeObjectSettings, this.deleteObjectSettings, this.cancelResumableWriteSettings, this.getObjectSettings, this.updateObjectSettings, this.listObjectsSettings, this.rewriteObjectSettings, this.startResumableWriteSettings, this.queryWriteStatusSettings, this.getServiceAccountSettings, this.createHmacKeySettings, this.deleteHmacKeySettings, this.getHmacKeySettings, this.listHmacKeysSettings, this.updateHmacKeySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StorageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StorageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StorageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(StorageStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(StorageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.getBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.createBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.listBucketsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.lockBucketRetentionPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.updateBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.deleteNotificationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.getNotificationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.createNotificationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.listNotificationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.composeObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.deleteObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.cancelResumableWriteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.getObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.readObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.updateObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.listObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.rewriteObjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.startResumableWriteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.queryWriteStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.getServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.createHmacKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.deleteHmacKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.getHmacKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.listHmacKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            builder.updateHmacKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((java.lang.Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((java.lang.Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteBucketRequest, Empty> deleteBucketSettings() {
            return this.deleteBucketSettings;
        }

        public UnaryCallSettings.Builder<GetBucketRequest, Bucket> getBucketSettings() {
            return this.getBucketSettings;
        }

        public UnaryCallSettings.Builder<CreateBucketRequest, Bucket> createBucketSettings() {
            return this.createBucketSettings;
        }

        public PagedCallSettings.Builder<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings() {
            return this.listBucketsSettings;
        }

        public UnaryCallSettings.Builder<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings() {
            return this.lockBucketRetentionPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateBucketRequest, Bucket> updateBucketSettings() {
            return this.updateBucketSettings;
        }

        public UnaryCallSettings.Builder<DeleteNotificationRequest, Empty> deleteNotificationSettings() {
            return this.deleteNotificationSettings;
        }

        public UnaryCallSettings.Builder<GetNotificationRequest, Notification> getNotificationSettings() {
            return this.getNotificationSettings;
        }

        public UnaryCallSettings.Builder<CreateNotificationRequest, Notification> createNotificationSettings() {
            return this.createNotificationSettings;
        }

        public PagedCallSettings.Builder<ListNotificationsRequest, ListNotificationsResponse, StorageClient.ListNotificationsPagedResponse> listNotificationsSettings() {
            return this.listNotificationsSettings;
        }

        public UnaryCallSettings.Builder<ComposeObjectRequest, Object> composeObjectSettings() {
            return this.composeObjectSettings;
        }

        public UnaryCallSettings.Builder<DeleteObjectRequest, Empty> deleteObjectSettings() {
            return this.deleteObjectSettings;
        }

        public UnaryCallSettings.Builder<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings() {
            return this.cancelResumableWriteSettings;
        }

        public UnaryCallSettings.Builder<GetObjectRequest, Object> getObjectSettings() {
            return this.getObjectSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadObjectRequest, ReadObjectResponse> readObjectSettings() {
            return this.readObjectSettings;
        }

        public UnaryCallSettings.Builder<UpdateObjectRequest, Object> updateObjectSettings() {
            return this.updateObjectSettings;
        }

        public StreamingCallSettings.Builder<WriteObjectRequest, WriteObjectResponse> writeObjectSettings() {
            return this.writeObjectSettings;
        }

        public PagedCallSettings.Builder<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings() {
            return this.listObjectsSettings;
        }

        public UnaryCallSettings.Builder<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings() {
            return this.rewriteObjectSettings;
        }

        public UnaryCallSettings.Builder<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings() {
            return this.startResumableWriteSettings;
        }

        public UnaryCallSettings.Builder<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings() {
            return this.queryWriteStatusSettings;
        }

        public UnaryCallSettings.Builder<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings() {
            return this.getServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeySettings() {
            return this.createHmacKeySettings;
        }

        public UnaryCallSettings.Builder<DeleteHmacKeyRequest, Empty> deleteHmacKeySettings() {
            return this.deleteHmacKeySettings;
        }

        public UnaryCallSettings.Builder<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeySettings() {
            return this.getHmacKeySettings;
        }

        public PagedCallSettings.Builder<ListHmacKeysRequest, ListHmacKeysResponse, StorageClient.ListHmacKeysPagedResponse> listHmacKeysSettings() {
            return this.listHmacKeysSettings;
        }

        public UnaryCallSettings.Builder<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeySettings() {
            return this.updateHmacKeySettings;
        }

        public StorageStubSettings build() throws IOException {
            return new StorageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((java.lang.Object)"retry_policy_0_codes", (java.lang.Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((java.lang.Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((java.lang.Object)"retry_policy_0_params", (java.lang.Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

