/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class LinuxEncryptionExtensionUtil {
    LinuxEncryptionExtensionUtil() {
    }

    static String progressMessage(VirtualMachineExtensionInstanceView instanceView) {
        List<InstanceViewStatus> statuses = LinuxEncryptionExtensionUtil.instanceViewStatuses(instanceView);
        if (statuses.size() == 0) {
            return null;
        }
        return statuses.get(0).message();
    }

    static EncryptionStatus osDiskStatus(VirtualMachineExtensionInstanceView instanceView) {
        JsonNode subStatusNode = LinuxEncryptionExtensionUtil.instanceViewFirstSubStatus(instanceView);
        if (subStatusNode == null) {
            return EncryptionStatus.UNKNOWN;
        }
        JsonNode diskNode = subStatusNode.path("os");
        if (diskNode instanceof MissingNode) {
            return EncryptionStatus.UNKNOWN;
        }
        return EncryptionStatus.fromString(diskNode.asText());
    }

    static EncryptionStatus dataDiskStatus(VirtualMachineExtensionInstanceView instanceView) {
        JsonNode subStatusNode = LinuxEncryptionExtensionUtil.instanceViewFirstSubStatus(instanceView);
        if (subStatusNode == null) {
            return EncryptionStatus.UNKNOWN;
        }
        JsonNode diskNode = subStatusNode.path("data");
        if (diskNode instanceof MissingNode) {
            return EncryptionStatus.UNKNOWN;
        }
        return EncryptionStatus.fromString(diskNode.asText());
    }

    static List<InstanceViewStatus> instanceViewStatuses(VirtualMachineExtensionInstanceView instanceView) {
        if (instanceView == null || instanceView.statuses() == null) {
            return new ArrayList<InstanceViewStatus>();
        }
        return instanceView.statuses();
    }

    static JsonNode instanceViewFirstSubStatus(VirtualMachineExtensionInstanceView instanceView) {
        JsonNode rootNode;
        if (instanceView == null || instanceView.substatuses() == null) {
            return null;
        }
        List<InstanceViewStatus> instanceViewSubStatuses = instanceView.substatuses();
        if (instanceViewSubStatuses.size() == 0) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootNode = mapper.readTree(instanceViewSubStatuses.get(0).message());
        }
        catch (IOException exception) {
            return null;
        }
        return rootNode;
    }
}

