/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/versionInfo.properties";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            userAgent = String.format("cos-java-sdk-v%s/%s/jdk-%s/%s", VersionInfoUtils.getVersion(), System.getProperty("os.name"), System.getProperty("java.version"), System.getProperty("java.vm.name"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfoUtils.class.getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (Exception e) {
            log.info("Unable to load version information for the running SDK: " + e.getMessage());
            version = "unknown-version";
            platform = "java";
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        log = LoggerFactory.getLogger(VersionInfoUtils.class);
    }
}

