/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.TroubleshootingResultInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.NetworkWatcher;
import com.azure.resourcemanager.network.models.Troubleshooting;
import com.azure.resourcemanager.network.models.TroubleshootingDetails;
import com.azure.resourcemanager.network.models.TroubleshootingParameters;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import java.time.OffsetDateTime;
import java.util.List;
import reactor.core.publisher.Mono;

class TroubleshootingImpl
extends ExecutableImpl<Troubleshooting>
implements Troubleshooting,
Troubleshooting.Definition {
    private final NetworkWatcherImpl parent;
    private TroubleshootingParameters parameters = new TroubleshootingParameters();
    private TroubleshootingResultInner result;

    TroubleshootingImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public TroubleshootingImpl withTargetResourceId(String targetResourceId) {
        this.parameters.withTargetResourceId(targetResourceId);
        return this;
    }

    @Override
    public TroubleshootingImpl withStorageAccount(String storageAccountId) {
        this.parameters.withStorageId(storageAccountId);
        return this;
    }

    @Override
    public TroubleshootingImpl withStoragePath(String storagePath) {
        this.parameters.withStoragePath(storagePath);
        return this;
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public Mono<Troubleshooting> executeWorkAsync() {
        return ((NetworkManagementClient)((NetworkManager)((Object)this.parent().manager())).serviceClient()).getNetworkWatchers().getTroubleshootingAsync(this.parent.resourceGroupName(), this.parent.name(), this.parameters).map(troubleshootingResultInner -> {
            this.result = troubleshootingResultInner;
            return this;
        });
    }

    @Override
    public String targetResourceId() {
        return this.parameters.targetResourceId();
    }

    @Override
    public String storageId() {
        return this.parameters.storageId();
    }

    @Override
    public String storagePath() {
        return this.parameters.storagePath();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.result.startTime();
    }

    @Override
    public OffsetDateTime endTime() {
        return this.result.endTime();
    }

    @Override
    public String code() {
        return this.result.code();
    }

    @Override
    public List<TroubleshootingDetails> results() {
        return this.result.results();
    }
}

