/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.cosmos.fluent.CosmosDBManagementClient;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBAccountsImpl;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientBuilder;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccounts;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class CosmosManager
extends Manager<CosmosDBManagementClient> {
    private CosmosDBAccountsImpl databaseAccounts;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static CosmosManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return CosmosManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    public static CosmosManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new CosmosManager(httpPipeline, profile);
    }

    private CosmosManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new CosmosDBManagementClientBuilder().endpoint(profile.getEnvironment().getResourceManagerEndpoint()).pipeline(httpPipeline).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public CosmosDBAccounts databaseAccounts() {
        if (this.databaseAccounts == null) {
            this.databaseAccounts = new CosmosDBAccountsImpl(this);
        }
        return this.databaseAccounts;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public CosmosManager authenticate(TokenCredential credential, AzureProfile profile) {
            return CosmosManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public CosmosManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

