/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.NetworkConfigurationDiagnosticProfile;
import com.azure.resourcemanager.network.models.VerbosityLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkConfigurationDiagnosticParameters {
    @JsonProperty(value="targetResourceId", required=true)
    private String targetResourceId;
    @JsonProperty(value="verbosityLevel")
    private VerbosityLevel verbosityLevel;
    @JsonProperty(value="profiles", required=true)
    private List<NetworkConfigurationDiagnosticProfile> profiles;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkConfigurationDiagnosticParameters.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public NetworkConfigurationDiagnosticParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public VerbosityLevel verbosityLevel() {
        return this.verbosityLevel;
    }

    public NetworkConfigurationDiagnosticParameters withVerbosityLevel(VerbosityLevel verbosityLevel) {
        this.verbosityLevel = verbosityLevel;
        return this;
    }

    public List<NetworkConfigurationDiagnosticProfile> profiles() {
        return this.profiles;
    }

    public NetworkConfigurationDiagnosticParameters withProfiles(List<NetworkConfigurationDiagnosticProfile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model NetworkConfigurationDiagnosticParameters"));
        }
        if (this.profiles() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property profiles in model NetworkConfigurationDiagnosticParameters"));
        }
        this.profiles().forEach(e -> e.validate());
    }
}

