/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventBuilder;
import io.kubernetes.client.openapi.models.CoreV1EventFluentImpl;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.CoreV1EventListFluent;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.openapi.models.V1ListMetaBuilder;
import io.kubernetes.client.openapi.models.V1ListMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CoreV1EventListFluentImpl<A extends CoreV1EventListFluent<A>>
extends BaseFluent<A>
implements CoreV1EventListFluent<A> {
    private String apiVersion;
    private List<CoreV1EventBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public CoreV1EventListFluentImpl() {
    }

    public CoreV1EventListFluentImpl(CoreV1EventList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String original) {
        return this.withApiVersion(new String(original));
    }

    @Override
    public A addToItems(int index, CoreV1Event item) {
        if (this.items == null) {
            this.items = new ArrayList<CoreV1EventBuilder>();
        }
        CoreV1EventBuilder builder = new CoreV1EventBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, CoreV1Event item) {
        if (this.items == null) {
            this.items = new ArrayList<CoreV1EventBuilder>();
        }
        CoreV1EventBuilder builder = new CoreV1EventBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(CoreV1Event ... items) {
        if (this.items == null) {
            this.items = new ArrayList<CoreV1EventBuilder>();
        }
        for (CoreV1Event item : items) {
            CoreV1EventBuilder builder = new CoreV1EventBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<CoreV1Event> items) {
        if (this.items == null) {
            this.items = new ArrayList<CoreV1EventBuilder>();
        }
        for (CoreV1Event item : items) {
            CoreV1EventBuilder builder = new CoreV1EventBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(CoreV1Event ... items) {
        for (CoreV1Event item : items) {
            CoreV1EventBuilder builder = new CoreV1EventBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<CoreV1Event> items) {
        for (CoreV1Event item : items) {
            CoreV1EventBuilder builder = new CoreV1EventBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<CoreV1EventBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<CoreV1EventBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            CoreV1EventBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CoreV1Event> getItems() {
        return CoreV1EventListFluentImpl.build(this.items);
    }

    @Override
    public List<CoreV1Event> buildItems() {
        return CoreV1EventListFluentImpl.build(this.items);
    }

    @Override
    public CoreV1Event buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public CoreV1Event buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public CoreV1Event buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public CoreV1Event buildMatchingItem(Predicate<CoreV1EventBuilder> predicate) {
        for (CoreV1EventBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<CoreV1EventBuilder> predicate) {
        for (CoreV1EventBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<CoreV1Event> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<CoreV1EventBuilder>();
            for (CoreV1Event item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(CoreV1Event ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (CoreV1Event item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> addNewItemLike(CoreV1Event item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> setNewItemLike(int index, CoreV1Event item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public CoreV1EventListFluent.ItemsNested<A> editMatchingItem(Predicate<CoreV1EventBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String original) {
        return this.withKind(new String(original));
    }

    @Override
    @Deprecated
    public V1ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ListMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public CoreV1EventListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public CoreV1EventListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public CoreV1EventListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public CoreV1EventListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ListMetaBuilder().build());
    }

    @Override
    public CoreV1EventListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreV1EventListFluentImpl that = (CoreV1EventListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends V1ListMetaFluentImpl<CoreV1EventListFluent.MetadataNested<N>>
    implements CoreV1EventListFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ListMetaBuilder builder;

        MetadataNestedImpl(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends CoreV1EventFluentImpl<CoreV1EventListFluent.ItemsNested<N>>
    implements CoreV1EventListFluent.ItemsNested<N>,
    Nested<N> {
        private final CoreV1EventBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, CoreV1Event item) {
            this.index = index;
            this.builder = new CoreV1EventBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new CoreV1EventBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

