/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.FactoriesClient;
import com.azure.resourcemanager.datafactory.fluent.models.AccessPolicyResponseInner;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryInner;
import com.azure.resourcemanager.datafactory.fluent.models.GitHubAccessTokenResponseInner;
import com.azure.resourcemanager.datafactory.implementation.AccessPolicyResponseImpl;
import com.azure.resourcemanager.datafactory.implementation.FactoryImpl;
import com.azure.resourcemanager.datafactory.implementation.GitHubAccessTokenResponseImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.AccessPolicyResponse;
import com.azure.resourcemanager.datafactory.models.Factories;
import com.azure.resourcemanager.datafactory.models.Factory;
import com.azure.resourcemanager.datafactory.models.FactoryRepoUpdate;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenRequest;
import com.azure.resourcemanager.datafactory.models.GitHubAccessTokenResponse;
import com.azure.resourcemanager.datafactory.models.UserAccessPolicy;

public final class FactoriesImpl
implements Factories {
    private static final ClientLogger LOGGER = new ClientLogger(FactoriesImpl.class);
    private final FactoriesClient innerClient;
    private final DataFactoryManager serviceManager;

    public FactoriesImpl(FactoriesClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Factory> list() {
        PagedIterable<FactoryInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new FactoryImpl((FactoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Factory> list(Context context) {
        PagedIterable<FactoryInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new FactoryImpl((FactoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Factory> configureFactoryRepoWithResponse(String locationId, FactoryRepoUpdate factoryRepoUpdate, Context context) {
        Response<FactoryInner> inner = this.serviceClient().configureFactoryRepoWithResponse(locationId, factoryRepoUpdate, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FactoryImpl((FactoryInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Factory configureFactoryRepo(String locationId, FactoryRepoUpdate factoryRepoUpdate) {
        FactoryInner inner = this.serviceClient().configureFactoryRepo(locationId, factoryRepoUpdate);
        if (inner != null) {
            return new FactoryImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Factory> listByResourceGroup(String resourceGroupName) {
        PagedIterable<FactoryInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new FactoryImpl((FactoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Factory> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<FactoryInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new FactoryImpl((FactoryInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Factory> getByResourceGroupWithResponse(String resourceGroupName, String factoryName, String ifNoneMatch, Context context) {
        Response<FactoryInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, factoryName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FactoryImpl((FactoryInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Factory getByResourceGroup(String resourceGroupName, String factoryName) {
        FactoryInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, factoryName);
        if (inner != null) {
            return new FactoryImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String factoryName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String factoryName) {
        this.serviceClient().delete(resourceGroupName, factoryName);
    }

    @Override
    public Response<GitHubAccessTokenResponse> getGitHubAccessTokenWithResponse(String resourceGroupName, String factoryName, GitHubAccessTokenRequest gitHubAccessTokenRequest, Context context) {
        Response<GitHubAccessTokenResponseInner> inner = this.serviceClient().getGitHubAccessTokenWithResponse(resourceGroupName, factoryName, gitHubAccessTokenRequest, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitHubAccessTokenResponseImpl((GitHubAccessTokenResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GitHubAccessTokenResponse getGitHubAccessToken(String resourceGroupName, String factoryName, GitHubAccessTokenRequest gitHubAccessTokenRequest) {
        GitHubAccessTokenResponseInner inner = this.serviceClient().getGitHubAccessToken(resourceGroupName, factoryName, gitHubAccessTokenRequest);
        if (inner != null) {
            return new GitHubAccessTokenResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AccessPolicyResponse> getDataPlaneAccessWithResponse(String resourceGroupName, String factoryName, UserAccessPolicy policy, Context context) {
        Response<AccessPolicyResponseInner> inner = this.serviceClient().getDataPlaneAccessWithResponse(resourceGroupName, factoryName, policy, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AccessPolicyResponseImpl((AccessPolicyResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AccessPolicyResponse getDataPlaneAccess(String resourceGroupName, String factoryName, UserAccessPolicy policy) {
        AccessPolicyResponseInner inner = this.serviceClient().getDataPlaneAccess(resourceGroupName, factoryName, policy);
        if (inner != null) {
            return new AccessPolicyResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Factory getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String localIfNoneMatch = null;
        return (Factory)this.getByResourceGroupWithResponse(resourceGroupName, factoryName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<Factory> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, factoryName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, factoryName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, factoryName, context);
    }

    private FactoriesClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public FactoryImpl define(String name) {
        return new FactoryImpl(name, this.manager());
    }
}

