/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.datafactory.implementation.PrivateLinkResourcesWrapperImpl;
import com.azure.resourcemanager.datafactory.models.PrivateLinkResources;
import com.azure.resourcemanager.datafactory.models.PrivateLinkResourcesWrapper;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final DataFactoryManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateLinkResourcesWrapper> getWithResponse(String resourceGroupName, String factoryName, Context context) {
        Response<PrivateLinkResourcesWrapperInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourcesWrapperImpl((PrivateLinkResourcesWrapperInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResourcesWrapper get(String resourceGroupName, String factoryName) {
        PrivateLinkResourcesWrapperInner inner = this.serviceClient().get(resourceGroupName, factoryName);
        if (inner != null) {
            return new PrivateLinkResourcesWrapperImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }
}

